/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.services.elasticloadbalancingv2.model.RevocationContent;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RevocationContentStaxUnmarshaller
implements Unmarshaller<RevocationContent, StaxUnmarshallerContext> {
    private static RevocationContentStaxUnmarshaller instance;

    public RevocationContent unmarshall(StaxUnmarshallerContext context) throws Exception {
        RevocationContent revocationContent = new RevocationContent();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return revocationContent;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("S3Bucket", targetDepth)) {
                    revocationContent.setS3Bucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3Key", targetDepth)) {
                    revocationContent.setS3Key(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3ObjectVersion", targetDepth)) {
                    revocationContent.setS3ObjectVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("RevocationType", targetDepth)) continue;
                revocationContent.setRevocationType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return revocationContent;
    }

    public static RevocationContentStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RevocationContentStaxUnmarshaller();
        }
        return instance;
    }
}

