/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.SubnetMapping;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SetSubnetsRequestMarshaller
implements Marshaller<Request<SetSubnetsRequest>, SetSubnetsRequest> {
    public Request<SetSubnetsRequest> marshall(SetSubnetsRequest setSubnetsRequest) {
        if (setSubnetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSubnetsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "SetSubnets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setSubnetsRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)setSubnetsRequest.getLoadBalancerArn()));
        }
        if (setSubnetsRequest.getSubnets() != null) {
            List<String> subnetsList = setSubnetsRequest.getSubnets();
            if (subnetsList.isEmpty()) {
                request.addParameter("Subnets", "");
            } else {
                int subnetsListIndex = 1;
                for (String subnetsListValue : subnetsList) {
                    if (subnetsListValue != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString((String)subnetsListValue));
                    }
                    ++subnetsListIndex;
                }
            }
        }
        if (setSubnetsRequest.getSubnetMappings() != null) {
            List<SubnetMapping> subnetMappingsList = setSubnetsRequest.getSubnetMappings();
            if (subnetMappingsList.isEmpty()) {
                request.addParameter("SubnetMappings", "");
            } else {
                int subnetMappingsListIndex = 1;
                for (SubnetMapping subnetMappingsListValue : subnetMappingsList) {
                    if (subnetMappingsListValue != null) {
                        if (subnetMappingsListValue.getSubnetId() != null) {
                            request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".SubnetId", StringUtils.fromString((String)subnetMappingsListValue.getSubnetId()));
                        }
                        if (subnetMappingsListValue.getAllocationId() != null) {
                            request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".AllocationId", StringUtils.fromString((String)subnetMappingsListValue.getAllocationId()));
                        }
                        if (subnetMappingsListValue.getPrivateIPv4Address() != null) {
                            request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".PrivateIPv4Address", StringUtils.fromString((String)subnetMappingsListValue.getPrivateIPv4Address()));
                        }
                        if (subnetMappingsListValue.getIPv6Address() != null) {
                            request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".IPv6Address", StringUtils.fromString((String)subnetMappingsListValue.getIPv6Address()));
                        }
                    }
                    ++subnetMappingsListIndex;
                }
            }
        }
        if (setSubnetsRequest.getIpAddressType() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString((String)setSubnetsRequest.getIpAddressType()));
        }
        return request;
    }
}

