/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.SubnetMapping;
import com.amazonaws.services.elasticloadbalancingv2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        if (createLoadBalancerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createLoadBalancerRequest.getName()));
        }
        if (createLoadBalancerRequest.getSubnets() != null) {
            List<String> subnetsList = createLoadBalancerRequest.getSubnets();
            if (subnetsList.isEmpty()) {
                request.addParameter("Subnets", "");
            } else {
                int subnetsListIndex = 1;
                for (String subnetsListValue : subnetsList) {
                    if (subnetsListValue != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString((String)subnetsListValue));
                    }
                    ++subnetsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getSubnetMappings() != null) {
            List<SubnetMapping> subnetMappingsList = createLoadBalancerRequest.getSubnetMappings();
            if (subnetMappingsList.isEmpty()) {
                request.addParameter("SubnetMappings", "");
            } else {
                int subnetMappingsListIndex = 1;
                for (SubnetMapping subnetMappingsListValue : subnetMappingsList) {
                    if (subnetMappingsListValue.getSubnetId() != null) {
                        request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".SubnetId", StringUtils.fromString((String)subnetMappingsListValue.getSubnetId()));
                    }
                    if (subnetMappingsListValue.getAllocationId() != null) {
                        request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".AllocationId", StringUtils.fromString((String)subnetMappingsListValue.getAllocationId()));
                    }
                    ++subnetMappingsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getSecurityGroups() != null) {
            List<String> securityGroupsList = createLoadBalancerRequest.getSecurityGroups();
            if (securityGroupsList.isEmpty()) {
                request.addParameter("SecurityGroups", "");
            } else {
                int securityGroupsListIndex = 1;
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue != null) {
                        request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getScheme() != null) {
            request.addParameter("Scheme", StringUtils.fromString((String)createLoadBalancerRequest.getScheme()));
        }
        if (createLoadBalancerRequest.getTags() != null) {
            List<Tag> tagsList = createLoadBalancerRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                    ++tagsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createLoadBalancerRequest.getType()));
        }
        if (createLoadBalancerRequest.getIpAddressType() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString((String)createLoadBalancerRequest.getIpAddressType()));
        }
        return request;
    }
}

