/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> resourceArns;
    private List<Tag> tags;

    public List<String> getResourceArns() {
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        this.resourceArns = new ArrayList<String>(resourceArns);
    }

    public AddTagsRequest withResourceArns(String ... resourceArns) {
        if (this.resourceArns == null) {
            this.setResourceArns(new ArrayList<String>(resourceArns.length));
        }
        for (String ele : resourceArns) {
            this.resourceArns.add(ele);
        }
        return this;
    }

    public AddTagsRequest withResourceArns(Collection<String> resourceArns) {
        this.setResourceArns(resourceArns);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public AddTagsRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public AddTagsRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: " + this.getResourceArns() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsRequest)) {
            return false;
        }
        AddTagsRequest other = (AddTagsRequest)obj;
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public AddTagsRequest clone() {
        return (AddTagsRequest)super.clone();
    }
}

