/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstanceHealthRequestMarshaller
implements Marshaller<Request<DescribeInstanceHealthRequest>, DescribeInstanceHealthRequest> {
    public Request<DescribeInstanceHealthRequest> marshall(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        if (describeInstanceHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceHealthRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeInstanceHealth");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceHealthRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)describeInstanceHealthRequest.getLoadBalancerName()));
        }
        if (!describeInstanceHealthRequest.getInstances().isEmpty() || !((SdkInternalList)describeInstanceHealthRequest.getInstances()).isAutoConstruct()) {
            SdkInternalList instancesList = (SdkInternalList)describeInstanceHealthRequest.getInstances();
            int instancesListIndex = 1;
            for (Instance instancesListValue : instancesList) {
                if (instancesListValue.getInstanceId() != null) {
                    request.addParameter("Instances.member." + instancesListIndex + ".InstanceId", StringUtils.fromString((String)instancesListValue.getInstanceId()));
                }
                ++instancesListIndex;
            }
        }
        return request;
    }
}

