/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeInstanceHealthRequestMarshaller
implements Marshaller<Request<DescribeInstanceHealthRequest>, DescribeInstanceHealthRequest> {
    public Request<DescribeInstanceHealthRequest> marshall(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        if (describeInstanceHealthRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceHealthRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeInstanceHealth");
        request.addParameter("Version", "2012-06-01");
        if (describeInstanceHealthRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)describeInstanceHealthRequest.getLoadBalancerName()));
        }
        List<Instance> instancesList = describeInstanceHealthRequest.getInstances();
        int instancesListIndex = 1;
        for (Instance instancesListValue : instancesList) {
            Instance instanceMember = instancesListValue;
            if (instanceMember != null && instanceMember.getInstanceId() != null) {
                request.addParameter("Instances.member." + instancesListIndex + ".InstanceId", StringUtils.fromString((String)instanceMember.getInstanceId()));
            }
            ++instancesListIndex;
        }
        return request;
    }
}

