/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticinference;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticinference.AmazonElasticInferenceAsync;
import com.amazonaws.services.elasticinference.AmazonElasticInferenceAsyncClientBuilder;
import com.amazonaws.services.elasticinference.AmazonElasticInferenceClient;
import com.amazonaws.services.elasticinference.model.DescribeAcceleratorOfferingsRequest;
import com.amazonaws.services.elasticinference.model.DescribeAcceleratorOfferingsResult;
import com.amazonaws.services.elasticinference.model.DescribeAcceleratorTypesRequest;
import com.amazonaws.services.elasticinference.model.DescribeAcceleratorTypesResult;
import com.amazonaws.services.elasticinference.model.DescribeAcceleratorsRequest;
import com.amazonaws.services.elasticinference.model.DescribeAcceleratorsResult;
import com.amazonaws.services.elasticinference.model.ListTagsForResourceRequest;
import com.amazonaws.services.elasticinference.model.ListTagsForResourceResult;
import com.amazonaws.services.elasticinference.model.TagResourceRequest;
import com.amazonaws.services.elasticinference.model.TagResourceResult;
import com.amazonaws.services.elasticinference.model.UntagResourceRequest;
import com.amazonaws.services.elasticinference.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonElasticInferenceAsyncClient
extends AmazonElasticInferenceClient
implements AmazonElasticInferenceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonElasticInferenceAsyncClientBuilder asyncBuilder() {
        return AmazonElasticInferenceAsyncClientBuilder.standard();
    }

    AmazonElasticInferenceAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonElasticInferenceAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeAcceleratorOfferingsResult> describeAcceleratorOfferingsAsync(DescribeAcceleratorOfferingsRequest request) {
        return this.describeAcceleratorOfferingsAsync(request, null);
    }

    @Override
    public Future<DescribeAcceleratorOfferingsResult> describeAcceleratorOfferingsAsync(DescribeAcceleratorOfferingsRequest request, final AsyncHandler<DescribeAcceleratorOfferingsRequest, DescribeAcceleratorOfferingsResult> asyncHandler) {
        final DescribeAcceleratorOfferingsRequest finalRequest = (DescribeAcceleratorOfferingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAcceleratorOfferingsResult>(){

            @Override
            public DescribeAcceleratorOfferingsResult call() throws Exception {
                DescribeAcceleratorOfferingsResult result = null;
                try {
                    result = AmazonElasticInferenceAsyncClient.this.executeDescribeAcceleratorOfferings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAcceleratorTypesResult> describeAcceleratorTypesAsync(DescribeAcceleratorTypesRequest request) {
        return this.describeAcceleratorTypesAsync(request, null);
    }

    @Override
    public Future<DescribeAcceleratorTypesResult> describeAcceleratorTypesAsync(DescribeAcceleratorTypesRequest request, final AsyncHandler<DescribeAcceleratorTypesRequest, DescribeAcceleratorTypesResult> asyncHandler) {
        final DescribeAcceleratorTypesRequest finalRequest = (DescribeAcceleratorTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAcceleratorTypesResult>(){

            @Override
            public DescribeAcceleratorTypesResult call() throws Exception {
                DescribeAcceleratorTypesResult result = null;
                try {
                    result = AmazonElasticInferenceAsyncClient.this.executeDescribeAcceleratorTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAcceleratorsResult> describeAcceleratorsAsync(DescribeAcceleratorsRequest request) {
        return this.describeAcceleratorsAsync(request, null);
    }

    @Override
    public Future<DescribeAcceleratorsResult> describeAcceleratorsAsync(DescribeAcceleratorsRequest request, final AsyncHandler<DescribeAcceleratorsRequest, DescribeAcceleratorsResult> asyncHandler) {
        final DescribeAcceleratorsRequest finalRequest = (DescribeAcceleratorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAcceleratorsResult>(){

            @Override
            public DescribeAcceleratorsResult call() throws Exception {
                DescribeAcceleratorsResult result = null;
                try {
                    result = AmazonElasticInferenceAsyncClient.this.executeDescribeAccelerators(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonElasticInferenceAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonElasticInferenceAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonElasticInferenceAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

