/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ComposeEnvironmentsRequestMarshaller
implements Marshaller<Request<ComposeEnvironmentsRequest>, ComposeEnvironmentsRequest> {
    public Request<ComposeEnvironmentsRequest> marshall(ComposeEnvironmentsRequest composeEnvironmentsRequest) {
        if (composeEnvironmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)composeEnvironmentsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "ComposeEnvironments");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (composeEnvironmentsRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)composeEnvironmentsRequest.getApplicationName()));
        }
        if (composeEnvironmentsRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)composeEnvironmentsRequest.getGroupName()));
        }
        if (!composeEnvironmentsRequest.getVersionLabels().isEmpty() || !((SdkInternalList)composeEnvironmentsRequest.getVersionLabels()).isAutoConstruct()) {
            SdkInternalList versionLabelsList = (SdkInternalList)composeEnvironmentsRequest.getVersionLabels();
            int versionLabelsListIndex = 1;
            for (String versionLabelsListValue : versionLabelsList) {
                if (versionLabelsListValue != null) {
                    request.addParameter("VersionLabels.member." + versionLabelsListIndex, StringUtils.fromString((String)versionLabelsListValue));
                }
                ++versionLabelsListIndex;
            }
        }
        return request;
    }
}

