/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.MaxAgeRule;
import com.amazonaws.services.elasticbeanstalk.model.MaxCountRule;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateApplicationRequestMarshaller
implements Marshaller<Request<CreateApplicationRequest>, CreateApplicationRequest> {
    public Request<CreateApplicationRequest> marshall(CreateApplicationRequest createApplicationRequest) {
        ApplicationResourceLifecycleConfig resourceLifecycleConfig;
        if (createApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createApplicationRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateApplication");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createApplicationRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createApplicationRequest.getApplicationName()));
        }
        if (createApplicationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createApplicationRequest.getDescription()));
        }
        if ((resourceLifecycleConfig = createApplicationRequest.getResourceLifecycleConfig()) != null) {
            ApplicationVersionLifecycleConfig versionLifecycleConfig;
            if (resourceLifecycleConfig.getServiceRole() != null) {
                request.addParameter("ResourceLifecycleConfig.ServiceRole", StringUtils.fromString((String)resourceLifecycleConfig.getServiceRole()));
            }
            if ((versionLifecycleConfig = resourceLifecycleConfig.getVersionLifecycleConfig()) != null) {
                MaxAgeRule maxAgeRule;
                MaxCountRule maxCountRule = versionLifecycleConfig.getMaxCountRule();
                if (maxCountRule != null) {
                    if (maxCountRule.getEnabled() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.Enabled", StringUtils.fromBoolean((Boolean)maxCountRule.getEnabled()));
                    }
                    if (maxCountRule.getMaxCount() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.MaxCount", StringUtils.fromInteger((Integer)maxCountRule.getMaxCount()));
                    }
                    if (maxCountRule.getDeleteSourceFromS3() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.DeleteSourceFromS3", StringUtils.fromBoolean((Boolean)maxCountRule.getDeleteSourceFromS3()));
                    }
                }
                if ((maxAgeRule = versionLifecycleConfig.getMaxAgeRule()) != null) {
                    if (maxAgeRule.getEnabled() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.Enabled", StringUtils.fromBoolean((Boolean)maxAgeRule.getEnabled()));
                    }
                    if (maxAgeRule.getMaxAgeInDays() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.MaxAgeInDays", StringUtils.fromInteger((Integer)maxAgeRule.getMaxAgeInDays()));
                    }
                    if (maxAgeRule.getDeleteSourceFromS3() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.DeleteSourceFromS3", StringUtils.fromBoolean((Boolean)maxAgeRule.getDeleteSourceFromS3()));
                    }
                }
            }
        }
        return request;
    }
}

