/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DescribeEnvironmentsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String versionLabel;
    private SdkInternalList<String> environmentIds;
    private SdkInternalList<String> environmentNames;
    private Boolean includeDeleted;
    private Date includedDeletedBackTo;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public DescribeEnvironmentsRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public DescribeEnvironmentsRequest withVersionLabel(String versionLabel) {
        this.setVersionLabel(versionLabel);
        return this;
    }

    public List<String> getEnvironmentIds() {
        if (this.environmentIds == null) {
            this.environmentIds = new SdkInternalList();
        }
        return this.environmentIds;
    }

    public void setEnvironmentIds(Collection<String> environmentIds) {
        if (environmentIds == null) {
            this.environmentIds = null;
            return;
        }
        this.environmentIds = new SdkInternalList(environmentIds);
    }

    public DescribeEnvironmentsRequest withEnvironmentIds(String ... environmentIds) {
        if (this.environmentIds == null) {
            this.setEnvironmentIds((Collection<String>)new SdkInternalList(environmentIds.length));
        }
        for (String ele : environmentIds) {
            this.environmentIds.add((Object)ele);
        }
        return this;
    }

    public DescribeEnvironmentsRequest withEnvironmentIds(Collection<String> environmentIds) {
        this.setEnvironmentIds(environmentIds);
        return this;
    }

    public List<String> getEnvironmentNames() {
        if (this.environmentNames == null) {
            this.environmentNames = new SdkInternalList();
        }
        return this.environmentNames;
    }

    public void setEnvironmentNames(Collection<String> environmentNames) {
        if (environmentNames == null) {
            this.environmentNames = null;
            return;
        }
        this.environmentNames = new SdkInternalList(environmentNames);
    }

    public DescribeEnvironmentsRequest withEnvironmentNames(String ... environmentNames) {
        if (this.environmentNames == null) {
            this.setEnvironmentNames((Collection<String>)new SdkInternalList(environmentNames.length));
        }
        for (String ele : environmentNames) {
            this.environmentNames.add((Object)ele);
        }
        return this;
    }

    public DescribeEnvironmentsRequest withEnvironmentNames(Collection<String> environmentNames) {
        this.setEnvironmentNames(environmentNames);
        return this;
    }

    public void setIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public Boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    public DescribeEnvironmentsRequest withIncludeDeleted(Boolean includeDeleted) {
        this.setIncludeDeleted(includeDeleted);
        return this;
    }

    public Boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    public void setIncludedDeletedBackTo(Date includedDeletedBackTo) {
        this.includedDeletedBackTo = includedDeletedBackTo;
    }

    public Date getIncludedDeletedBackTo() {
        return this.includedDeletedBackTo;
    }

    public DescribeEnvironmentsRequest withIncludedDeletedBackTo(Date includedDeletedBackTo) {
        this.setIncludedDeletedBackTo(includedDeletedBackTo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getVersionLabel() != null) {
            sb.append("VersionLabel: " + this.getVersionLabel() + ",");
        }
        if (this.getEnvironmentIds() != null) {
            sb.append("EnvironmentIds: " + this.getEnvironmentIds() + ",");
        }
        if (this.getEnvironmentNames() != null) {
            sb.append("EnvironmentNames: " + this.getEnvironmentNames() + ",");
        }
        if (this.getIncludeDeleted() != null) {
            sb.append("IncludeDeleted: " + this.getIncludeDeleted() + ",");
        }
        if (this.getIncludedDeletedBackTo() != null) {
            sb.append("IncludedDeletedBackTo: " + this.getIncludedDeletedBackTo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsRequest)) {
            return false;
        }
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null) {
            return false;
        }
        if (other.getVersionLabel() != null && !other.getVersionLabel().equals(this.getVersionLabel())) {
            return false;
        }
        if (other.getEnvironmentIds() == null ^ this.getEnvironmentIds() == null) {
            return false;
        }
        if (other.getEnvironmentIds() != null && !other.getEnvironmentIds().equals(this.getEnvironmentIds())) {
            return false;
        }
        if (other.getEnvironmentNames() == null ^ this.getEnvironmentNames() == null) {
            return false;
        }
        if (other.getEnvironmentNames() != null && !other.getEnvironmentNames().equals(this.getEnvironmentNames())) {
            return false;
        }
        if (other.getIncludeDeleted() == null ^ this.getIncludeDeleted() == null) {
            return false;
        }
        if (other.getIncludeDeleted() != null && !other.getIncludeDeleted().equals(this.getIncludeDeleted())) {
            return false;
        }
        if (other.getIncludedDeletedBackTo() == null ^ this.getIncludedDeletedBackTo() == null) {
            return false;
        }
        return other.getIncludedDeletedBackTo() == null || other.getIncludedDeletedBackTo().equals(this.getIncludedDeletedBackTo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabel() == null ? 0 : this.getVersionLabel().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentIds() == null ? 0 : this.getEnvironmentIds().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentNames() == null ? 0 : this.getEnvironmentNames().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeDeleted() == null ? 0 : this.getIncludeDeleted().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedDeletedBackTo() == null ? 0 : this.getIncludedDeletedBackTo().hashCode());
        return hashCode;
    }

    public DescribeEnvironmentsRequest clone() {
        return (DescribeEnvironmentsRequest)super.clone();
    }
}

