/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ConfigureShard;
import com.amazonaws.services.elasticache.model.DecreaseReplicaCountRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DecreaseReplicaCountRequestMarshaller
implements Marshaller<Request<DecreaseReplicaCountRequest>, DecreaseReplicaCountRequest> {
    public Request<DecreaseReplicaCountRequest> marshall(DecreaseReplicaCountRequest decreaseReplicaCountRequest) {
        if (decreaseReplicaCountRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)decreaseReplicaCountRequest, "AmazonElastiCache");
        request.addParameter("Action", "DecreaseReplicaCount");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (decreaseReplicaCountRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)decreaseReplicaCountRequest.getReplicationGroupId()));
        }
        if (decreaseReplicaCountRequest.getNewReplicaCount() != null) {
            request.addParameter("NewReplicaCount", StringUtils.fromInteger((Integer)decreaseReplicaCountRequest.getNewReplicaCount()));
        }
        if (!decreaseReplicaCountRequest.getReplicaConfiguration().isEmpty() || !((SdkInternalList)decreaseReplicaCountRequest.getReplicaConfiguration()).isAutoConstruct()) {
            SdkInternalList replicaConfigurationList = (SdkInternalList)decreaseReplicaCountRequest.getReplicaConfiguration();
            int replicaConfigurationListIndex = 1;
            for (ConfigureShard replicaConfigurationListValue : replicaConfigurationList) {
                if (replicaConfigurationListValue != null) {
                    if (replicaConfigurationListValue.getNodeGroupId() != null) {
                        request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".NodeGroupId", StringUtils.fromString((String)replicaConfigurationListValue.getNodeGroupId()));
                    }
                    if (replicaConfigurationListValue.getNewReplicaCount() != null) {
                        request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".NewReplicaCount", StringUtils.fromInteger((Integer)replicaConfigurationListValue.getNewReplicaCount()));
                    }
                    if (!replicaConfigurationListValue.getPreferredAvailabilityZones().isEmpty() || !((SdkInternalList)replicaConfigurationListValue.getPreferredAvailabilityZones()).isAutoConstruct()) {
                        SdkInternalList preferredAvailabilityZonesList = (SdkInternalList)replicaConfigurationListValue.getPreferredAvailabilityZones();
                        int preferredAvailabilityZonesListIndex = 1;
                        for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                            if (preferredAvailabilityZonesListValue != null) {
                                request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".PreferredAvailabilityZones.PreferredAvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString((String)preferredAvailabilityZonesListValue));
                            }
                            ++preferredAvailabilityZonesListIndex;
                        }
                    }
                    if (!replicaConfigurationListValue.getPreferredOutpostArns().isEmpty() || !((SdkInternalList)replicaConfigurationListValue.getPreferredOutpostArns()).isAutoConstruct()) {
                        SdkInternalList preferredOutpostArnsList = (SdkInternalList)replicaConfigurationListValue.getPreferredOutpostArns();
                        int preferredOutpostArnsListIndex = 1;
                        for (String preferredOutpostArnsListValue : preferredOutpostArnsList) {
                            if (preferredOutpostArnsListValue != null) {
                                request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".PreferredOutpostArns.PreferredOutpostArn." + preferredOutpostArnsListIndex, StringUtils.fromString((String)preferredOutpostArnsListValue));
                            }
                            ++preferredOutpostArnsListIndex;
                        }
                    }
                }
                ++replicaConfigurationListIndex;
            }
        }
        if (!decreaseReplicaCountRequest.getReplicasToRemove().isEmpty() || !((SdkInternalList)decreaseReplicaCountRequest.getReplicasToRemove()).isAutoConstruct()) {
            SdkInternalList replicasToRemoveList = (SdkInternalList)decreaseReplicaCountRequest.getReplicasToRemove();
            int replicasToRemoveListIndex = 1;
            for (String replicasToRemoveListValue : replicasToRemoveList) {
                if (replicasToRemoveListValue != null) {
                    request.addParameter("ReplicasToRemove.member." + replicasToRemoveListIndex, StringUtils.fromString((String)replicasToRemoveListValue));
                }
                ++replicasToRemoveListIndex;
            }
        }
        if (decreaseReplicaCountRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)decreaseReplicaCountRequest.getApplyImmediately()));
        }
        return request;
    }
}

