/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.AvailabilityZone;
import com.amazonaws.services.elasticache.model.NetworkType;
import com.amazonaws.services.elasticache.model.SubnetOutpost;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Subnet
implements Serializable,
Cloneable {
    private String subnetIdentifier;
    private AvailabilityZone subnetAvailabilityZone;
    private SubnetOutpost subnetOutpost;
    private SdkInternalList<String> supportedNetworkTypes;

    public void setSubnetIdentifier(String subnetIdentifier) {
        this.subnetIdentifier = subnetIdentifier;
    }

    public String getSubnetIdentifier() {
        return this.subnetIdentifier;
    }

    public Subnet withSubnetIdentifier(String subnetIdentifier) {
        this.setSubnetIdentifier(subnetIdentifier);
        return this;
    }

    public void setSubnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
        this.subnetAvailabilityZone = subnetAvailabilityZone;
    }

    public AvailabilityZone getSubnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public Subnet withSubnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
        this.setSubnetAvailabilityZone(subnetAvailabilityZone);
        return this;
    }

    public void setSubnetOutpost(SubnetOutpost subnetOutpost) {
        this.subnetOutpost = subnetOutpost;
    }

    public SubnetOutpost getSubnetOutpost() {
        return this.subnetOutpost;
    }

    public Subnet withSubnetOutpost(SubnetOutpost subnetOutpost) {
        this.setSubnetOutpost(subnetOutpost);
        return this;
    }

    public List<String> getSupportedNetworkTypes() {
        if (this.supportedNetworkTypes == null) {
            this.supportedNetworkTypes = new SdkInternalList();
        }
        return this.supportedNetworkTypes;
    }

    public void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
        if (supportedNetworkTypes == null) {
            this.supportedNetworkTypes = null;
            return;
        }
        this.supportedNetworkTypes = new SdkInternalList(supportedNetworkTypes);
    }

    public Subnet withSupportedNetworkTypes(String ... supportedNetworkTypes) {
        if (this.supportedNetworkTypes == null) {
            this.setSupportedNetworkTypes((Collection<String>)new SdkInternalList(supportedNetworkTypes.length));
        }
        for (String ele : supportedNetworkTypes) {
            this.supportedNetworkTypes.add((Object)ele);
        }
        return this;
    }

    public Subnet withSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
        this.setSupportedNetworkTypes(supportedNetworkTypes);
        return this;
    }

    public Subnet withSupportedNetworkTypes(NetworkType ... supportedNetworkTypes) {
        SdkInternalList supportedNetworkTypesCopy = new SdkInternalList(supportedNetworkTypes.length);
        for (NetworkType value : supportedNetworkTypes) {
            supportedNetworkTypesCopy.add((Object)value.toString());
        }
        if (this.getSupportedNetworkTypes() == null) {
            this.setSupportedNetworkTypes((Collection<String>)supportedNetworkTypesCopy);
        } else {
            this.getSupportedNetworkTypes().addAll((Collection<String>)supportedNetworkTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetIdentifier() != null) {
            sb.append("SubnetIdentifier: ").append(this.getSubnetIdentifier()).append(",");
        }
        if (this.getSubnetAvailabilityZone() != null) {
            sb.append("SubnetAvailabilityZone: ").append(this.getSubnetAvailabilityZone()).append(",");
        }
        if (this.getSubnetOutpost() != null) {
            sb.append("SubnetOutpost: ").append(this.getSubnetOutpost()).append(",");
        }
        if (this.getSupportedNetworkTypes() != null) {
            sb.append("SupportedNetworkTypes: ").append(this.getSupportedNetworkTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        if (other.getSubnetIdentifier() == null ^ this.getSubnetIdentifier() == null) {
            return false;
        }
        if (other.getSubnetIdentifier() != null && !other.getSubnetIdentifier().equals(this.getSubnetIdentifier())) {
            return false;
        }
        if (other.getSubnetAvailabilityZone() == null ^ this.getSubnetAvailabilityZone() == null) {
            return false;
        }
        if (other.getSubnetAvailabilityZone() != null && !other.getSubnetAvailabilityZone().equals(this.getSubnetAvailabilityZone())) {
            return false;
        }
        if (other.getSubnetOutpost() == null ^ this.getSubnetOutpost() == null) {
            return false;
        }
        if (other.getSubnetOutpost() != null && !other.getSubnetOutpost().equals(this.getSubnetOutpost())) {
            return false;
        }
        if (other.getSupportedNetworkTypes() == null ^ this.getSupportedNetworkTypes() == null) {
            return false;
        }
        return other.getSupportedNetworkTypes() == null || other.getSupportedNetworkTypes().equals(this.getSupportedNetworkTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetIdentifier() == null ? 0 : this.getSubnetIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetAvailabilityZone() == null ? 0 : this.getSubnetAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetOutpost() == null ? 0 : this.getSubnetOutpost().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedNetworkTypes() == null ? 0 : this.getSupportedNetworkTypes().hashCode());
        return hashCode;
    }

    public Subnet clone() {
        try {
            return (Subnet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

