/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.AuthenticationMode;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class AuthenticationModeStaxUnmarshaller
implements Unmarshaller<AuthenticationMode, StaxUnmarshallerContext> {
    private static AuthenticationModeStaxUnmarshaller instance;

    public AuthenticationMode unmarshall(StaxUnmarshallerContext context) throws Exception {
        AuthenticationMode authenticationMode = new AuthenticationMode();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return authenticationMode;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Type", targetDepth)) {
                    authenticationMode.setType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Passwords", targetDepth)) {
                    authenticationMode.withPasswords(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Passwords/member", targetDepth)) continue;
                authenticationMode.withPasswords(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return authenticationMode;
    }

    public static AuthenticationModeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AuthenticationModeStaxUnmarshaller();
        }
        return instance;
    }
}

