/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.NetworkType;
import com.amazonaws.services.elasticache.model.Subnet;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CacheSubnetGroup
implements Serializable,
Cloneable {
    private String cacheSubnetGroupName;
    private String cacheSubnetGroupDescription;
    private String vpcId;
    private SdkInternalList<Subnet> subnets;
    private String aRN;
    private SdkInternalList<String> supportedNetworkTypes;

    public void setCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
    }

    public String getCacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public CacheSubnetGroup withCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.setCacheSubnetGroupName(cacheSubnetGroupName);
        return this;
    }

    public void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
        this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
    }

    public String getCacheSubnetGroupDescription() {
        return this.cacheSubnetGroupDescription;
    }

    public CacheSubnetGroup withCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
        this.setCacheSubnetGroupDescription(cacheSubnetGroupDescription);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public CacheSubnetGroup withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<Subnet> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new SdkInternalList();
        }
        return this.subnets;
    }

    public void setSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new SdkInternalList(subnets);
    }

    public CacheSubnetGroup withSubnets(Subnet ... subnets) {
        if (this.subnets == null) {
            this.setSubnets((Collection<Subnet>)new SdkInternalList(subnets.length));
        }
        for (Subnet ele : subnets) {
            this.subnets.add((Object)ele);
        }
        return this;
    }

    public CacheSubnetGroup withSubnets(Collection<Subnet> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public CacheSubnetGroup withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public List<String> getSupportedNetworkTypes() {
        if (this.supportedNetworkTypes == null) {
            this.supportedNetworkTypes = new SdkInternalList();
        }
        return this.supportedNetworkTypes;
    }

    public void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
        if (supportedNetworkTypes == null) {
            this.supportedNetworkTypes = null;
            return;
        }
        this.supportedNetworkTypes = new SdkInternalList(supportedNetworkTypes);
    }

    public CacheSubnetGroup withSupportedNetworkTypes(String ... supportedNetworkTypes) {
        if (this.supportedNetworkTypes == null) {
            this.setSupportedNetworkTypes((Collection<String>)new SdkInternalList(supportedNetworkTypes.length));
        }
        for (String ele : supportedNetworkTypes) {
            this.supportedNetworkTypes.add((Object)ele);
        }
        return this;
    }

    public CacheSubnetGroup withSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
        this.setSupportedNetworkTypes(supportedNetworkTypes);
        return this;
    }

    public CacheSubnetGroup withSupportedNetworkTypes(NetworkType ... supportedNetworkTypes) {
        SdkInternalList supportedNetworkTypesCopy = new SdkInternalList(supportedNetworkTypes.length);
        for (NetworkType value : supportedNetworkTypes) {
            supportedNetworkTypesCopy.add((Object)value.toString());
        }
        if (this.getSupportedNetworkTypes() == null) {
            this.setSupportedNetworkTypes((Collection<String>)supportedNetworkTypesCopy);
        } else {
            this.getSupportedNetworkTypes().addAll((Collection<String>)supportedNetworkTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: ").append(this.getCacheSubnetGroupName()).append(",");
        }
        if (this.getCacheSubnetGroupDescription() != null) {
            sb.append("CacheSubnetGroupDescription: ").append(this.getCacheSubnetGroupDescription()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getSupportedNetworkTypes() != null) {
            sb.append("SupportedNetworkTypes: ").append(this.getSupportedNetworkTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSubnetGroup)) {
            return false;
        }
        CacheSubnetGroup other = (CacheSubnetGroup)obj;
        if (other.getCacheSubnetGroupName() == null ^ this.getCacheSubnetGroupName() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupName() != null && !other.getCacheSubnetGroupName().equals(this.getCacheSubnetGroupName())) {
            return false;
        }
        if (other.getCacheSubnetGroupDescription() == null ^ this.getCacheSubnetGroupDescription() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupDescription() != null && !other.getCacheSubnetGroupDescription().equals(this.getCacheSubnetGroupDescription())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !other.getSubnets().equals(this.getSubnets())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getSupportedNetworkTypes() == null ^ this.getSupportedNetworkTypes() == null) {
            return false;
        }
        return other.getSupportedNetworkTypes() == null || other.getSupportedNetworkTypes().equals(this.getSupportedNetworkTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupName() == null ? 0 : this.getCacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupDescription() == null ? 0 : this.getCacheSubnetGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedNetworkTypes() == null ? 0 : this.getSupportedNetworkTypes().hashCode());
        return hashCode;
    }

    public CacheSubnetGroup clone() {
        try {
            return (CacheSubnetGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

