/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticache.model.CopySnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopySnapshotRequestMarshaller
implements Marshaller<Request<CopySnapshotRequest>, CopySnapshotRequest> {
    public Request<CopySnapshotRequest> marshall(CopySnapshotRequest copySnapshotRequest) {
        if (copySnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copySnapshotRequest, "AmazonElastiCache");
        request.addParameter("Action", "CopySnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (copySnapshotRequest.getSourceSnapshotName() != null) {
            request.addParameter("SourceSnapshotName", StringUtils.fromString((String)copySnapshotRequest.getSourceSnapshotName()));
        }
        if (copySnapshotRequest.getTargetSnapshotName() != null) {
            request.addParameter("TargetSnapshotName", StringUtils.fromString((String)copySnapshotRequest.getTargetSnapshotName()));
        }
        if (copySnapshotRequest.getTargetBucket() != null) {
            request.addParameter("TargetBucket", StringUtils.fromString((String)copySnapshotRequest.getTargetBucket()));
        }
        return request;
    }
}

