/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eks.model.AddonVersionInfo;
import java.util.List;

@SdkInternalApi
public class AddonVersionInfoMarshaller {
    private static final MarshallingInfo<String> ADDONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addonVersion").build();
    private static final MarshallingInfo<List> ARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("architecture").build();
    private static final MarshallingInfo<List> COMPATIBILITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("compatibilities").build();
    private static final MarshallingInfo<Boolean> REQUIRESCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requiresConfiguration").build();
    private static final MarshallingInfo<Boolean> REQUIRESIAMPERMISSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requiresIamPermissions").build();
    private static final AddonVersionInfoMarshaller instance = new AddonVersionInfoMarshaller();

    public static AddonVersionInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(AddonVersionInfo addonVersionInfo, ProtocolMarshaller protocolMarshaller) {
        if (addonVersionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)addonVersionInfo.getAddonVersion(), ADDONVERSION_BINDING);
            protocolMarshaller.marshall(addonVersionInfo.getArchitecture(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall(addonVersionInfo.getCompatibilities(), COMPATIBILITIES_BINDING);
            protocolMarshaller.marshall((Object)addonVersionInfo.getRequiresConfiguration(), REQUIRESCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)addonVersionInfo.getRequiresIamPermissions(), REQUIRESIAMPERMISSIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

