/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.eks.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The health status of the Fargate profile. If there are issues with your Fargate profile's health, they are listed
 * here.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/FargateProfileHealth" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FargateProfileHealth implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Any issues that are associated with the Fargate profile.
     * </p>
     */
    private java.util.List<FargateProfileIssue> issues;

    /**
     * <p>
     * Any issues that are associated with the Fargate profile.
     * </p>
     * 
     * @return Any issues that are associated with the Fargate profile.
     */

    public java.util.List<FargateProfileIssue> getIssues() {
        return issues;
    }

    /**
     * <p>
     * Any issues that are associated with the Fargate profile.
     * </p>
     * 
     * @param issues
     *        Any issues that are associated with the Fargate profile.
     */

    public void setIssues(java.util.Collection<FargateProfileIssue> issues) {
        if (issues == null) {
            this.issues = null;
            return;
        }

        this.issues = new java.util.ArrayList<FargateProfileIssue>(issues);
    }

    /**
     * <p>
     * Any issues that are associated with the Fargate profile.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIssues(java.util.Collection)} or {@link #withIssues(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param issues
     *        Any issues that are associated with the Fargate profile.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FargateProfileHealth withIssues(FargateProfileIssue... issues) {
        if (this.issues == null) {
            setIssues(new java.util.ArrayList<FargateProfileIssue>(issues.length));
        }
        for (FargateProfileIssue ele : issues) {
            this.issues.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Any issues that are associated with the Fargate profile.
     * </p>
     * 
     * @param issues
     *        Any issues that are associated with the Fargate profile.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FargateProfileHealth withIssues(java.util.Collection<FargateProfileIssue> issues) {
        setIssues(issues);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIssues() != null)
            sb.append("Issues: ").append(getIssues());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FargateProfileHealth == false)
            return false;
        FargateProfileHealth other = (FargateProfileHealth) obj;
        if (other.getIssues() == null ^ this.getIssues() == null)
            return false;
        if (other.getIssues() != null && other.getIssues().equals(this.getIssues()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIssues() == null) ? 0 : getIssues().hashCode());
        return hashCode;
    }

    @Override
    public FargateProfileHealth clone() {
        try {
            return (FargateProfileHealth) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.eks.model.transform.FargateProfileHealthMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
