/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.ClientStat;
import com.amazonaws.services.eks.model.transform.DeprecationDetailMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeprecationDetail
implements Serializable,
Cloneable,
StructuredPojo {
    private String usage;
    private String replacedWith;
    private String stopServingVersion;
    private String startServingReplacementVersion;
    private List<ClientStat> clientStats;

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getUsage() {
        return this.usage;
    }

    public DeprecationDetail withUsage(String usage) {
        this.setUsage(usage);
        return this;
    }

    public void setReplacedWith(String replacedWith) {
        this.replacedWith = replacedWith;
    }

    public String getReplacedWith() {
        return this.replacedWith;
    }

    public DeprecationDetail withReplacedWith(String replacedWith) {
        this.setReplacedWith(replacedWith);
        return this;
    }

    public void setStopServingVersion(String stopServingVersion) {
        this.stopServingVersion = stopServingVersion;
    }

    public String getStopServingVersion() {
        return this.stopServingVersion;
    }

    public DeprecationDetail withStopServingVersion(String stopServingVersion) {
        this.setStopServingVersion(stopServingVersion);
        return this;
    }

    public void setStartServingReplacementVersion(String startServingReplacementVersion) {
        this.startServingReplacementVersion = startServingReplacementVersion;
    }

    public String getStartServingReplacementVersion() {
        return this.startServingReplacementVersion;
    }

    public DeprecationDetail withStartServingReplacementVersion(String startServingReplacementVersion) {
        this.setStartServingReplacementVersion(startServingReplacementVersion);
        return this;
    }

    public List<ClientStat> getClientStats() {
        return this.clientStats;
    }

    public void setClientStats(Collection<ClientStat> clientStats) {
        if (clientStats == null) {
            this.clientStats = null;
            return;
        }
        this.clientStats = new ArrayList<ClientStat>(clientStats);
    }

    public DeprecationDetail withClientStats(ClientStat ... clientStats) {
        if (this.clientStats == null) {
            this.setClientStats(new ArrayList<ClientStat>(clientStats.length));
        }
        for (ClientStat ele : clientStats) {
            this.clientStats.add(ele);
        }
        return this;
    }

    public DeprecationDetail withClientStats(Collection<ClientStat> clientStats) {
        this.setClientStats(clientStats);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsage() != null) {
            sb.append("Usage: ").append(this.getUsage()).append(",");
        }
        if (this.getReplacedWith() != null) {
            sb.append("ReplacedWith: ").append(this.getReplacedWith()).append(",");
        }
        if (this.getStopServingVersion() != null) {
            sb.append("StopServingVersion: ").append(this.getStopServingVersion()).append(",");
        }
        if (this.getStartServingReplacementVersion() != null) {
            sb.append("StartServingReplacementVersion: ").append(this.getStartServingReplacementVersion()).append(",");
        }
        if (this.getClientStats() != null) {
            sb.append("ClientStats: ").append(this.getClientStats());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecationDetail)) {
            return false;
        }
        DeprecationDetail other = (DeprecationDetail)obj;
        if (other.getUsage() == null ^ this.getUsage() == null) {
            return false;
        }
        if (other.getUsage() != null && !other.getUsage().equals(this.getUsage())) {
            return false;
        }
        if (other.getReplacedWith() == null ^ this.getReplacedWith() == null) {
            return false;
        }
        if (other.getReplacedWith() != null && !other.getReplacedWith().equals(this.getReplacedWith())) {
            return false;
        }
        if (other.getStopServingVersion() == null ^ this.getStopServingVersion() == null) {
            return false;
        }
        if (other.getStopServingVersion() != null && !other.getStopServingVersion().equals(this.getStopServingVersion())) {
            return false;
        }
        if (other.getStartServingReplacementVersion() == null ^ this.getStartServingReplacementVersion() == null) {
            return false;
        }
        if (other.getStartServingReplacementVersion() != null && !other.getStartServingReplacementVersion().equals(this.getStartServingReplacementVersion())) {
            return false;
        }
        if (other.getClientStats() == null ^ this.getClientStats() == null) {
            return false;
        }
        return other.getClientStats() == null || other.getClientStats().equals(this.getClientStats());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsage() == null ? 0 : this.getUsage().hashCode());
        hashCode = 31 * hashCode + (this.getReplacedWith() == null ? 0 : this.getReplacedWith().hashCode());
        hashCode = 31 * hashCode + (this.getStopServingVersion() == null ? 0 : this.getStopServingVersion().hashCode());
        hashCode = 31 * hashCode + (this.getStartServingReplacementVersion() == null ? 0 : this.getStartServingReplacementVersion().hashCode());
        hashCode = 31 * hashCode + (this.getClientStats() == null ? 0 : this.getClientStats().hashCode());
        return hashCode;
    }

    public DeprecationDetail clone() {
        try {
            return (DeprecationDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeprecationDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

