/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eks.model.AccessEntry;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class AccessEntryMarshaller {
    private static final MarshallingInfo<String> CLUSTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterName").build();
    private static final MarshallingInfo<String> PRINCIPALARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principalArn").build();
    private static final MarshallingInfo<List> KUBERNETESGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kubernetesGroups").build();
    private static final MarshallingInfo<String> ACCESSENTRYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessEntryArn").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> MODIFIEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("modifiedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final AccessEntryMarshaller instance = new AccessEntryMarshaller();

    public static AccessEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(AccessEntry accessEntry, ProtocolMarshaller protocolMarshaller) {
        if (accessEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)accessEntry.getClusterName(), CLUSTERNAME_BINDING);
            protocolMarshaller.marshall((Object)accessEntry.getPrincipalArn(), PRINCIPALARN_BINDING);
            protocolMarshaller.marshall(accessEntry.getKubernetesGroups(), KUBERNETESGROUPS_BINDING);
            protocolMarshaller.marshall((Object)accessEntry.getAccessEntryArn(), ACCESSENTRYARN_BINDING);
            protocolMarshaller.marshall((Object)accessEntry.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)accessEntry.getModifiedAt(), MODIFIEDAT_BINDING);
            protocolMarshaller.marshall(accessEntry.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)accessEntry.getUsername(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)accessEntry.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

