/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.Issue;
import com.amazonaws.services.eks.model.transform.NodegroupHealthMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodegroupHealth
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Issue> issues;

    public List<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(Collection<Issue> issues) {
        if (issues == null) {
            this.issues = null;
            return;
        }
        this.issues = new ArrayList<Issue>(issues);
    }

    public NodegroupHealth withIssues(Issue ... issues) {
        if (this.issues == null) {
            this.setIssues(new ArrayList<Issue>(issues.length));
        }
        for (Issue ele : issues) {
            this.issues.add(ele);
        }
        return this;
    }

    public NodegroupHealth withIssues(Collection<Issue> issues) {
        this.setIssues(issues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIssues() != null) {
            sb.append("Issues: ").append(this.getIssues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupHealth)) {
            return false;
        }
        NodegroupHealth other = (NodegroupHealth)obj;
        if (other.getIssues() == null ^ this.getIssues() == null) {
            return false;
        }
        return other.getIssues() == null || other.getIssues().equals(this.getIssues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIssues() == null ? 0 : this.getIssues().hashCode());
        return hashCode;
    }

    public NodegroupHealth clone() {
        try {
            return (NodegroupHealth)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NodegroupHealthMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

