/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.Nodegroup;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class NodegroupMarshaller {
    private static final MarshallingInfo<String> NODEGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodegroupName").build();
    private static final MarshallingInfo<String> NODEGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodegroupArn").build();
    private static final MarshallingInfo<String> CLUSTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterName").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> RELEASEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("releaseVersion").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> MODIFIEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("modifiedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> CAPACITYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("capacityType").build();
    private static final MarshallingInfo<StructuredPojo> SCALINGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scalingConfig").build();
    private static final MarshallingInfo<List> INSTANCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceTypes").build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnets").build();
    private static final MarshallingInfo<StructuredPojo> REMOTEACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remoteAccess").build();
    private static final MarshallingInfo<String> AMITYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amiType").build();
    private static final MarshallingInfo<String> NODEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodeRole").build();
    private static final MarshallingInfo<Map> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("labels").build();
    private static final MarshallingInfo<List> TAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taints").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resources").build();
    private static final MarshallingInfo<Integer> DISKSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diskSize").build();
    private static final MarshallingInfo<StructuredPojo> HEALTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("health").build();
    private static final MarshallingInfo<StructuredPojo> LAUNCHTEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchTemplate").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final NodegroupMarshaller instance = new NodegroupMarshaller();

    public static NodegroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(Nodegroup nodegroup, ProtocolMarshaller protocolMarshaller) {
        if (nodegroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)nodegroup.getNodegroupName(), NODEGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getNodegroupArn(), NODEGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getClusterName(), CLUSTERNAME_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getReleaseVersion(), RELEASEVERSION_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getModifiedAt(), MODIFIEDAT_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getCapacityType(), CAPACITYTYPE_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getScalingConfig(), SCALINGCONFIG_BINDING);
            protocolMarshaller.marshall(nodegroup.getInstanceTypes(), INSTANCETYPES_BINDING);
            protocolMarshaller.marshall(nodegroup.getSubnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getRemoteAccess(), REMOTEACCESS_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getAmiType(), AMITYPE_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getNodeRole(), NODEROLE_BINDING);
            protocolMarshaller.marshall(nodegroup.getLabels(), LABELS_BINDING);
            protocolMarshaller.marshall(nodegroup.getTaints(), TAINTS_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getResources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getDiskSize(), DISKSIZE_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getHealth(), HEALTH_BINDING);
            protocolMarshaller.marshall((Object)nodegroup.getLaunchTemplate(), LAUNCHTEMPLATE_BINDING);
            protocolMarshaller.marshall(nodegroup.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

