/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eks.model.Compatibility;
import java.util.List;

@SdkInternalApi
public class CompatibilityMarshaller {
    private static final MarshallingInfo<String> CLUSTERVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterVersion").build();
    private static final MarshallingInfo<List> PLATFORMVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platformVersions").build();
    private static final MarshallingInfo<Boolean> DEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultVersion").build();
    private static final CompatibilityMarshaller instance = new CompatibilityMarshaller();

    public static CompatibilityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Compatibility compatibility, ProtocolMarshaller protocolMarshaller) {
        if (compatibility == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)compatibility.getClusterVersion(), CLUSTERVERSION_BINDING);
            protocolMarshaller.marshall(compatibility.getPlatformVersions(), PLATFORMVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)compatibility.getDefaultVersion(), DEFAULTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

