/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticfilesystem.model.FileSystemDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeFileSystemsResult
implements Serializable,
Cloneable {
    private String marker;
    private ListWithAutoConstructFlag<FileSystemDescription> fileSystems;
    private String nextMarker;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeFileSystemsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<FileSystemDescription> getFileSystems() {
        if (this.fileSystems == null) {
            this.fileSystems = new ListWithAutoConstructFlag();
            this.fileSystems.setAutoConstruct(true);
        }
        return this.fileSystems;
    }

    public void setFileSystems(Collection<FileSystemDescription> fileSystems) {
        if (fileSystems == null) {
            this.fileSystems = null;
            return;
        }
        ListWithAutoConstructFlag fileSystemsCopy = new ListWithAutoConstructFlag(fileSystems.size());
        fileSystemsCopy.addAll(fileSystems);
        this.fileSystems = fileSystemsCopy;
    }

    public DescribeFileSystemsResult withFileSystems(FileSystemDescription ... fileSystems) {
        if (this.getFileSystems() == null) {
            this.setFileSystems(new ArrayList<FileSystemDescription>(fileSystems.length));
        }
        for (FileSystemDescription value : fileSystems) {
            this.getFileSystems().add(value);
        }
        return this;
    }

    public DescribeFileSystemsResult withFileSystems(Collection<FileSystemDescription> fileSystems) {
        if (fileSystems == null) {
            this.fileSystems = null;
        } else {
            ListWithAutoConstructFlag fileSystemsCopy = new ListWithAutoConstructFlag(fileSystems.size());
            fileSystemsCopy.addAll(fileSystems);
            this.fileSystems = fileSystemsCopy;
        }
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public DescribeFileSystemsResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getFileSystems() != null) {
            sb.append("FileSystems: " + this.getFileSystems() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystems() == null ? 0 : this.getFileSystems().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResult)) {
            return false;
        }
        DescribeFileSystemsResult other = (DescribeFileSystemsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getFileSystems() == null ^ this.getFileSystems() == null) {
            return false;
        }
        if (other.getFileSystems() != null && !other.getFileSystems().equals(this.getFileSystems())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        return other.getNextMarker() == null || other.getNextMarker().equals(this.getNextMarker());
    }

    public DescribeFileSystemsResult clone() {
        try {
            return (DescribeFileSystemsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

