/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemAsync;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemAsyncClientBuilder;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemClient;
import com.amazonaws.services.elasticfilesystem.model.CreateAccessPointRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateAccessPointResult;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteAccessPointRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteAccessPointResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemPolicyRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemPolicyResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeAccessPointsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeAccessPointsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeAccountPreferencesRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeAccountPreferencesResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeBackupPolicyRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeBackupPolicyResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemPolicyRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemPolicyResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeLifecycleConfigurationRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeLifecycleConfigurationResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsResult;
import com.amazonaws.services.elasticfilesystem.model.ListTagsForResourceRequest;
import com.amazonaws.services.elasticfilesystem.model.ListTagsForResourceResult;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.PutAccountPreferencesRequest;
import com.amazonaws.services.elasticfilesystem.model.PutAccountPreferencesResult;
import com.amazonaws.services.elasticfilesystem.model.PutBackupPolicyRequest;
import com.amazonaws.services.elasticfilesystem.model.PutBackupPolicyResult;
import com.amazonaws.services.elasticfilesystem.model.PutFileSystemPolicyRequest;
import com.amazonaws.services.elasticfilesystem.model.PutFileSystemPolicyResult;
import com.amazonaws.services.elasticfilesystem.model.PutLifecycleConfigurationRequest;
import com.amazonaws.services.elasticfilesystem.model.PutLifecycleConfigurationResult;
import com.amazonaws.services.elasticfilesystem.model.TagResourceRequest;
import com.amazonaws.services.elasticfilesystem.model.TagResourceResult;
import com.amazonaws.services.elasticfilesystem.model.UntagResourceRequest;
import com.amazonaws.services.elasticfilesystem.model.UntagResourceResult;
import com.amazonaws.services.elasticfilesystem.model.UpdateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.UpdateFileSystemResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonElasticFileSystemAsyncClient
extends AmazonElasticFileSystemClient
implements AmazonElasticFileSystemAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonElasticFileSystemAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonElasticFileSystemAsyncClientBuilder asyncBuilder() {
        return AmazonElasticFileSystemAsyncClientBuilder.standard();
    }

    AmazonElasticFileSystemAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonElasticFileSystemAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateAccessPointResult> createAccessPointAsync(CreateAccessPointRequest request) {
        return this.createAccessPointAsync(request, null);
    }

    @Override
    public Future<CreateAccessPointResult> createAccessPointAsync(CreateAccessPointRequest request, final AsyncHandler<CreateAccessPointRequest, CreateAccessPointResult> asyncHandler) {
        final CreateAccessPointRequest finalRequest = (CreateAccessPointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAccessPointResult>(){

            @Override
            public CreateAccessPointResult call() throws Exception {
                CreateAccessPointResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeCreateAccessPoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(CreateFileSystemRequest request) {
        return this.createFileSystemAsync(request, null);
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(CreateFileSystemRequest request, final AsyncHandler<CreateFileSystemRequest, CreateFileSystemResult> asyncHandler) {
        final CreateFileSystemRequest finalRequest = (CreateFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFileSystemResult>(){

            @Override
            public CreateFileSystemResult call() throws Exception {
                CreateFileSystemResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeCreateFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMountTargetResult> createMountTargetAsync(CreateMountTargetRequest request) {
        return this.createMountTargetAsync(request, null);
    }

    @Override
    public Future<CreateMountTargetResult> createMountTargetAsync(CreateMountTargetRequest request, final AsyncHandler<CreateMountTargetRequest, CreateMountTargetResult> asyncHandler) {
        final CreateMountTargetRequest finalRequest = (CreateMountTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMountTargetResult>(){

            @Override
            public CreateMountTargetResult call() throws Exception {
                CreateMountTargetResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeCreateMountTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        final CreateTagsRequest finalRequest = (CreateTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeCreateTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAccessPointResult> deleteAccessPointAsync(DeleteAccessPointRequest request) {
        return this.deleteAccessPointAsync(request, null);
    }

    @Override
    public Future<DeleteAccessPointResult> deleteAccessPointAsync(DeleteAccessPointRequest request, final AsyncHandler<DeleteAccessPointRequest, DeleteAccessPointResult> asyncHandler) {
        final DeleteAccessPointRequest finalRequest = (DeleteAccessPointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAccessPointResult>(){

            @Override
            public DeleteAccessPointResult call() throws Exception {
                DeleteAccessPointResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDeleteAccessPoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFileSystemResult> deleteFileSystemAsync(DeleteFileSystemRequest request) {
        return this.deleteFileSystemAsync(request, null);
    }

    @Override
    public Future<DeleteFileSystemResult> deleteFileSystemAsync(DeleteFileSystemRequest request, final AsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResult> asyncHandler) {
        final DeleteFileSystemRequest finalRequest = (DeleteFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFileSystemResult>(){

            @Override
            public DeleteFileSystemResult call() throws Exception {
                DeleteFileSystemResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDeleteFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFileSystemPolicyResult> deleteFileSystemPolicyAsync(DeleteFileSystemPolicyRequest request) {
        return this.deleteFileSystemPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteFileSystemPolicyResult> deleteFileSystemPolicyAsync(DeleteFileSystemPolicyRequest request, final AsyncHandler<DeleteFileSystemPolicyRequest, DeleteFileSystemPolicyResult> asyncHandler) {
        final DeleteFileSystemPolicyRequest finalRequest = (DeleteFileSystemPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFileSystemPolicyResult>(){

            @Override
            public DeleteFileSystemPolicyResult call() throws Exception {
                DeleteFileSystemPolicyResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDeleteFileSystemPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMountTargetResult> deleteMountTargetAsync(DeleteMountTargetRequest request) {
        return this.deleteMountTargetAsync(request, null);
    }

    @Override
    public Future<DeleteMountTargetResult> deleteMountTargetAsync(DeleteMountTargetRequest request, final AsyncHandler<DeleteMountTargetRequest, DeleteMountTargetResult> asyncHandler) {
        final DeleteMountTargetRequest finalRequest = (DeleteMountTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMountTargetResult>(){

            @Override
            public DeleteMountTargetResult call() throws Exception {
                DeleteMountTargetResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDeleteMountTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        final DeleteTagsRequest finalRequest = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDeleteTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccessPointsResult> describeAccessPointsAsync(DescribeAccessPointsRequest request) {
        return this.describeAccessPointsAsync(request, null);
    }

    @Override
    public Future<DescribeAccessPointsResult> describeAccessPointsAsync(DescribeAccessPointsRequest request, final AsyncHandler<DescribeAccessPointsRequest, DescribeAccessPointsResult> asyncHandler) {
        final DescribeAccessPointsRequest finalRequest = (DescribeAccessPointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAccessPointsResult>(){

            @Override
            public DescribeAccessPointsResult call() throws Exception {
                DescribeAccessPointsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeAccessPoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountPreferencesResult> describeAccountPreferencesAsync(DescribeAccountPreferencesRequest request) {
        return this.describeAccountPreferencesAsync(request, null);
    }

    @Override
    public Future<DescribeAccountPreferencesResult> describeAccountPreferencesAsync(DescribeAccountPreferencesRequest request, final AsyncHandler<DescribeAccountPreferencesRequest, DescribeAccountPreferencesResult> asyncHandler) {
        final DescribeAccountPreferencesRequest finalRequest = (DescribeAccountPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAccountPreferencesResult>(){

            @Override
            public DescribeAccountPreferencesResult call() throws Exception {
                DescribeAccountPreferencesResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeAccountPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBackupPolicyResult> describeBackupPolicyAsync(DescribeBackupPolicyRequest request) {
        return this.describeBackupPolicyAsync(request, null);
    }

    @Override
    public Future<DescribeBackupPolicyResult> describeBackupPolicyAsync(DescribeBackupPolicyRequest request, final AsyncHandler<DescribeBackupPolicyRequest, DescribeBackupPolicyResult> asyncHandler) {
        final DescribeBackupPolicyRequest finalRequest = (DescribeBackupPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBackupPolicyResult>(){

            @Override
            public DescribeBackupPolicyResult call() throws Exception {
                DescribeBackupPolicyResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeBackupPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemPolicyResult> describeFileSystemPolicyAsync(DescribeFileSystemPolicyRequest request) {
        return this.describeFileSystemPolicyAsync(request, null);
    }

    @Override
    public Future<DescribeFileSystemPolicyResult> describeFileSystemPolicyAsync(DescribeFileSystemPolicyRequest request, final AsyncHandler<DescribeFileSystemPolicyRequest, DescribeFileSystemPolicyResult> asyncHandler) {
        final DescribeFileSystemPolicyRequest finalRequest = (DescribeFileSystemPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFileSystemPolicyResult>(){

            @Override
            public DescribeFileSystemPolicyResult call() throws Exception {
                DescribeFileSystemPolicyResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeFileSystemPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(DescribeFileSystemsRequest request) {
        return this.describeFileSystemsAsync(request, null);
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(DescribeFileSystemsRequest request, final AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) {
        final DescribeFileSystemsRequest finalRequest = (DescribeFileSystemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFileSystemsResult>(){

            @Override
            public DescribeFileSystemsResult call() throws Exception {
                DescribeFileSystemsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeFileSystems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync() {
        return this.describeFileSystemsAsync(new DescribeFileSystemsRequest());
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) {
        return this.describeFileSystemsAsync(new DescribeFileSystemsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLifecycleConfigurationResult> describeLifecycleConfigurationAsync(DescribeLifecycleConfigurationRequest request) {
        return this.describeLifecycleConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeLifecycleConfigurationResult> describeLifecycleConfigurationAsync(DescribeLifecycleConfigurationRequest request, final AsyncHandler<DescribeLifecycleConfigurationRequest, DescribeLifecycleConfigurationResult> asyncHandler) {
        final DescribeLifecycleConfigurationRequest finalRequest = (DescribeLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLifecycleConfigurationResult>(){

            @Override
            public DescribeLifecycleConfigurationResult call() throws Exception {
                DescribeLifecycleConfigurationResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeLifecycleConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMountTargetSecurityGroupsResult> describeMountTargetSecurityGroupsAsync(DescribeMountTargetSecurityGroupsRequest request) {
        return this.describeMountTargetSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeMountTargetSecurityGroupsResult> describeMountTargetSecurityGroupsAsync(DescribeMountTargetSecurityGroupsRequest request, final AsyncHandler<DescribeMountTargetSecurityGroupsRequest, DescribeMountTargetSecurityGroupsResult> asyncHandler) {
        final DescribeMountTargetSecurityGroupsRequest finalRequest = (DescribeMountTargetSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMountTargetSecurityGroupsResult>(){

            @Override
            public DescribeMountTargetSecurityGroupsResult call() throws Exception {
                DescribeMountTargetSecurityGroupsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeMountTargetSecurityGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMountTargetsResult> describeMountTargetsAsync(DescribeMountTargetsRequest request) {
        return this.describeMountTargetsAsync(request, null);
    }

    @Override
    public Future<DescribeMountTargetsResult> describeMountTargetsAsync(DescribeMountTargetsRequest request, final AsyncHandler<DescribeMountTargetsRequest, DescribeMountTargetsResult> asyncHandler) {
        final DescribeMountTargetsRequest finalRequest = (DescribeMountTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMountTargetsResult>(){

            @Override
            public DescribeMountTargetsResult call() throws Exception {
                DescribeMountTargetsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeMountTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        final DescribeTagsRequest finalRequest = (DescribeTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyMountTargetSecurityGroupsResult> modifyMountTargetSecurityGroupsAsync(ModifyMountTargetSecurityGroupsRequest request) {
        return this.modifyMountTargetSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<ModifyMountTargetSecurityGroupsResult> modifyMountTargetSecurityGroupsAsync(ModifyMountTargetSecurityGroupsRequest request, final AsyncHandler<ModifyMountTargetSecurityGroupsRequest, ModifyMountTargetSecurityGroupsResult> asyncHandler) {
        final ModifyMountTargetSecurityGroupsRequest finalRequest = (ModifyMountTargetSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyMountTargetSecurityGroupsResult>(){

            @Override
            public ModifyMountTargetSecurityGroupsResult call() throws Exception {
                ModifyMountTargetSecurityGroupsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeModifyMountTargetSecurityGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAccountPreferencesResult> putAccountPreferencesAsync(PutAccountPreferencesRequest request) {
        return this.putAccountPreferencesAsync(request, null);
    }

    @Override
    public Future<PutAccountPreferencesResult> putAccountPreferencesAsync(PutAccountPreferencesRequest request, final AsyncHandler<PutAccountPreferencesRequest, PutAccountPreferencesResult> asyncHandler) {
        final PutAccountPreferencesRequest finalRequest = (PutAccountPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAccountPreferencesResult>(){

            @Override
            public PutAccountPreferencesResult call() throws Exception {
                PutAccountPreferencesResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executePutAccountPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutBackupPolicyResult> putBackupPolicyAsync(PutBackupPolicyRequest request) {
        return this.putBackupPolicyAsync(request, null);
    }

    @Override
    public Future<PutBackupPolicyResult> putBackupPolicyAsync(PutBackupPolicyRequest request, final AsyncHandler<PutBackupPolicyRequest, PutBackupPolicyResult> asyncHandler) {
        final PutBackupPolicyRequest finalRequest = (PutBackupPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutBackupPolicyResult>(){

            @Override
            public PutBackupPolicyResult call() throws Exception {
                PutBackupPolicyResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executePutBackupPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutFileSystemPolicyResult> putFileSystemPolicyAsync(PutFileSystemPolicyRequest request) {
        return this.putFileSystemPolicyAsync(request, null);
    }

    @Override
    public Future<PutFileSystemPolicyResult> putFileSystemPolicyAsync(PutFileSystemPolicyRequest request, final AsyncHandler<PutFileSystemPolicyRequest, PutFileSystemPolicyResult> asyncHandler) {
        final PutFileSystemPolicyRequest finalRequest = (PutFileSystemPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutFileSystemPolicyResult>(){

            @Override
            public PutFileSystemPolicyResult call() throws Exception {
                PutFileSystemPolicyResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executePutFileSystemPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLifecycleConfigurationResult> putLifecycleConfigurationAsync(PutLifecycleConfigurationRequest request) {
        return this.putLifecycleConfigurationAsync(request, null);
    }

    @Override
    public Future<PutLifecycleConfigurationResult> putLifecycleConfigurationAsync(PutLifecycleConfigurationRequest request, final AsyncHandler<PutLifecycleConfigurationRequest, PutLifecycleConfigurationResult> asyncHandler) {
        final PutLifecycleConfigurationRequest finalRequest = (PutLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutLifecycleConfigurationResult>(){

            @Override
            public PutLifecycleConfigurationResult call() throws Exception {
                PutLifecycleConfigurationResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executePutLifecycleConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFileSystemResult> updateFileSystemAsync(UpdateFileSystemRequest request) {
        return this.updateFileSystemAsync(request, null);
    }

    @Override
    public Future<UpdateFileSystemResult> updateFileSystemAsync(UpdateFileSystemRequest request, final AsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResult> asyncHandler) {
        final UpdateFileSystemRequest finalRequest = (UpdateFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFileSystemResult>(){

            @Override
            public UpdateFileSystemResult call() throws Exception {
                UpdateFileSystemResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeUpdateFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

