/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String fileSystemId;
    private SdkInternalList<Tag> tags;

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public CreateTagsRequest withFileSystemId(String fileSystemId) {
        this.setFileSystemId(fileSystemId);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateTagsRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateTagsRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileSystemId() != null) {
            sb.append("FileSystemId: " + this.getFileSystemId() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTagsRequest)) {
            return false;
        }
        CreateTagsRequest other = (CreateTagsRequest)obj;
        if (other.getFileSystemId() == null ^ this.getFileSystemId() == null) {
            return false;
        }
        if (other.getFileSystemId() != null && !other.getFileSystemId().equals(this.getFileSystemId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileSystemId() == null ? 0 : this.getFileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateTagsRequest clone() {
        return (CreateTagsRequest)super.clone();
    }
}

