/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.FileSystemDescription;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeFileSystemsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private SdkInternalList<FileSystemDescription> fileSystems;
    private String nextMarker;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeFileSystemsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<FileSystemDescription> getFileSystems() {
        if (this.fileSystems == null) {
            this.fileSystems = new SdkInternalList();
        }
        return this.fileSystems;
    }

    public void setFileSystems(Collection<FileSystemDescription> fileSystems) {
        if (fileSystems == null) {
            this.fileSystems = null;
            return;
        }
        this.fileSystems = new SdkInternalList(fileSystems);
    }

    public DescribeFileSystemsResult withFileSystems(FileSystemDescription ... fileSystems) {
        if (this.fileSystems == null) {
            this.setFileSystems((Collection<FileSystemDescription>)new SdkInternalList(fileSystems.length));
        }
        for (FileSystemDescription ele : fileSystems) {
            this.fileSystems.add((Object)ele);
        }
        return this;
    }

    public DescribeFileSystemsResult withFileSystems(Collection<FileSystemDescription> fileSystems) {
        this.setFileSystems(fileSystems);
        return this;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public DescribeFileSystemsResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getFileSystems() != null) {
            sb.append("FileSystems: ").append(this.getFileSystems()).append(",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResult)) {
            return false;
        }
        DescribeFileSystemsResult other = (DescribeFileSystemsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getFileSystems() == null ^ this.getFileSystems() == null) {
            return false;
        }
        if (other.getFileSystems() != null && !other.getFileSystems().equals(this.getFileSystems())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        return other.getNextMarker() == null || other.getNextMarker().equals(this.getNextMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystems() == null ? 0 : this.getFileSystems().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        return hashCode;
    }

    public DescribeFileSystemsResult clone() {
        try {
            return (DescribeFileSystemsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

