/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteFileSystemRequestMarshaller
implements Marshaller<Request<DeleteFileSystemRequest>, DeleteFileSystemRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteFileSystemRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteFileSystemRequest> marshall(DeleteFileSystemRequest deleteFileSystemRequest) {
        if (deleteFileSystemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteFileSystemRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-02-01/file-systems/{FileSystemId}";
        uriResourcePath = uriResourcePath.replace("{FileSystemId}", deleteFileSystemRequest.getFileSystemId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteFileSystemRequest.getFileSystemId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

