/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeFileSystemsRequestMarshaller
implements Marshaller<Request<DescribeFileSystemsRequest>, DescribeFileSystemsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<DescribeFileSystemsRequest> marshall(DescribeFileSystemsRequest describeFileSystemsRequest) {
        String fileSystemId;
        String creationToken;
        String marker;
        String maxItems;
        if (describeFileSystemsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFileSystemsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-02-01/file-systems";
        request.setResourcePath(uriResourcePath);
        String string = maxItems = describeFileSystemsRequest.getMaxItems() == null ? null : StringUtils.fromInteger((Integer)describeFileSystemsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("MaxItems", maxItems);
        }
        String string2 = marker = describeFileSystemsRequest.getMarker() == null ? null : StringUtils.fromString((String)describeFileSystemsRequest.getMarker());
        if (marker != null) {
            request.addParameter("Marker", marker);
        }
        String string3 = creationToken = describeFileSystemsRequest.getCreationToken() == null ? null : StringUtils.fromString((String)describeFileSystemsRequest.getCreationToken());
        if (creationToken != null) {
            request.addParameter("CreationToken", creationToken);
        }
        String string4 = fileSystemId = describeFileSystemsRequest.getFileSystemId() == null ? null : StringUtils.fromString((String)describeFileSystemsRequest.getFileSystemId());
        if (fileSystemId != null) {
            request.addParameter("FileSystemId", fileSystemId);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

