/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.AttachmentStateChange;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SubmitAttachmentStateChangesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<AttachmentStateChange> attachments;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public SubmitAttachmentStateChangesRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<AttachmentStateChange> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new SdkInternalList();
        }
        return this.attachments;
    }

    public void setAttachments(Collection<AttachmentStateChange> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        this.attachments = new SdkInternalList(attachments);
    }

    public SubmitAttachmentStateChangesRequest withAttachments(AttachmentStateChange ... attachments) {
        if (this.attachments == null) {
            this.setAttachments((Collection<AttachmentStateChange>)new SdkInternalList(attachments.length));
        }
        for (AttachmentStateChange ele : attachments) {
            this.attachments.add((Object)ele);
        }
        return this;
    }

    public SubmitAttachmentStateChangesRequest withAttachments(Collection<AttachmentStateChange> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getAttachments() != null) {
            sb.append("Attachments: ").append(this.getAttachments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitAttachmentStateChangesRequest)) {
            return false;
        }
        SubmitAttachmentStateChangesRequest other = (SubmitAttachmentStateChangesRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        return other.getAttachments() == null || other.getAttachments().equals(this.getAttachments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : this.getAttachments().hashCode());
        return hashCode;
    }

    public SubmitAttachmentStateChangesRequest clone() {
        return (SubmitAttachmentStateChangesRequest)super.clone();
    }
}

