/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.transform.ContainerDefinitionJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VolumeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RegisterTaskDefinitionRequestMarshaller
implements Marshaller<Request<RegisterTaskDefinitionRequest>, RegisterTaskDefinitionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterTaskDefinitionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RegisterTaskDefinitionRequest> marshall(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        if (registerTaskDefinitionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerTaskDefinitionRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.RegisterTaskDefinition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList volumesList;
            SdkInternalList containerDefinitionsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerTaskDefinitionRequest.getFamily() != null) {
                jsonGenerator.writeFieldName("family").writeValue(registerTaskDefinitionRequest.getFamily());
            }
            if (registerTaskDefinitionRequest.getTaskRoleArn() != null) {
                jsonGenerator.writeFieldName("taskRoleArn").writeValue(registerTaskDefinitionRequest.getTaskRoleArn());
            }
            if (registerTaskDefinitionRequest.getNetworkMode() != null) {
                jsonGenerator.writeFieldName("networkMode").writeValue(registerTaskDefinitionRequest.getNetworkMode());
            }
            if (!(containerDefinitionsList = (SdkInternalList)registerTaskDefinitionRequest.getContainerDefinitions()).isEmpty() || !containerDefinitionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("containerDefinitions");
                jsonGenerator.writeStartArray();
                for (Object containerDefinitionsListValue : containerDefinitionsList) {
                    if (containerDefinitionsListValue == null) continue;
                    ContainerDefinitionJsonMarshaller.getInstance().marshall((ContainerDefinition)containerDefinitionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(volumesList = (SdkInternalList)registerTaskDefinitionRequest.getVolumes()).isEmpty() || !volumesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("volumes");
                jsonGenerator.writeStartArray();
                for (Volume volumesListValue : volumesList) {
                    if (volumesListValue == null) continue;
                    VolumeJsonMarshaller.getInstance().marshall(volumesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

