/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.Container;
import java.util.List;

@SdkInternalApi
public class ContainerMarshaller {
    private static final MarshallingInfo<String> CONTAINERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerArn").build();
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").build();
    private static final MarshallingInfo<Integer> EXITCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exitCode").build();
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reason").build();
    private static final MarshallingInfo<List> NETWORKBINDINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkBindings").build();
    private static final MarshallingInfo<List> NETWORKINTERFACES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkInterfaces").build();
    private static final MarshallingInfo<String> HEALTHSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("healthStatus").build();
    private static final MarshallingInfo<String> CPU_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpu").build();
    private static final MarshallingInfo<String> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<String> MEMORYRESERVATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memoryReservation").build();
    private static final MarshallingInfo<List> GPUIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gpuIds").build();
    private static final ContainerMarshaller instance = new ContainerMarshaller();

    public static ContainerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Container container, ProtocolMarshaller protocolMarshaller) {
        if (container == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)container.getContainerArn(), CONTAINERARN_BINDING);
            protocolMarshaller.marshall((Object)container.getTaskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall((Object)container.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)container.getLastStatus(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)container.getExitCode(), EXITCODE_BINDING);
            protocolMarshaller.marshall((Object)container.getReason(), REASON_BINDING);
            protocolMarshaller.marshall(container.getNetworkBindings(), NETWORKBINDINGS_BINDING);
            protocolMarshaller.marshall(container.getNetworkInterfaces(), NETWORKINTERFACES_BINDING);
            protocolMarshaller.marshall((Object)container.getHealthStatus(), HEALTHSTATUS_BINDING);
            protocolMarshaller.marshall((Object)container.getCpu(), CPU_BINDING);
            protocolMarshaller.marshall((Object)container.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall((Object)container.getMemoryReservation(), MEMORYRESERVATION_BINDING);
            protocolMarshaller.marshall(container.getGpuIds(), GPUIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

