/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.TaskSet;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class TaskSetMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> TASKSETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskSetArn").build();
    private static final MarshallingInfo<String> STARTEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedBy").build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> TASKDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskDefinition").build();
    private static final MarshallingInfo<Integer> COMPUTEDDESIREDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computedDesiredCount").build();
    private static final MarshallingInfo<Integer> PENDINGCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pendingCount").build();
    private static final MarshallingInfo<Integer> RUNNINGCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("runningCount").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LAUNCHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchType").build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platformVersion").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkConfiguration").build();
    private static final MarshallingInfo<List> LOADBALANCERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loadBalancers").build();
    private static final MarshallingInfo<StructuredPojo> SCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scale").build();
    private static final MarshallingInfo<String> STABILITYSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stabilityStatus").build();
    private static final MarshallingInfo<Date> STABILITYSTATUSAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stabilityStatusAt").timestampFormat("unixTimestamp").build();
    private static final TaskSetMarshaller instance = new TaskSetMarshaller();

    public static TaskSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaskSet taskSet, ProtocolMarshaller protocolMarshaller) {
        if (taskSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)taskSet.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getTaskSetArn(), TASKSETARN_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getStartedBy(), STARTEDBY_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getExternalId(), EXTERNALID_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getTaskDefinition(), TASKDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getComputedDesiredCount(), COMPUTEDDESIREDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getPendingCount(), PENDINGCOUNT_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getRunningCount(), RUNNINGCOUNT_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getUpdatedAt(), UPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getLaunchType(), LAUNCHTYPE_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getPlatformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getNetworkConfiguration(), NETWORKCONFIGURATION_BINDING);
            protocolMarshaller.marshall(taskSet.getLoadBalancers(), LOADBALANCERS_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getScale(), SCALE_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getStabilityStatus(), STABILITYSTATUS_BINDING);
            protocolMarshaller.marshall((Object)taskSet.getStabilityStatusAt(), STABILITYSTATUSAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

