/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.AmazonECSClientBuilder;
import com.amazonaws.services.ecs.model.AccessDeniedException;
import com.amazonaws.services.ecs.model.AmazonECSException;
import com.amazonaws.services.ecs.model.AttributeLimitExceededException;
import com.amazonaws.services.ecs.model.BlockedException;
import com.amazonaws.services.ecs.model.ClientException;
import com.amazonaws.services.ecs.model.ClusterContainsContainerInstancesException;
import com.amazonaws.services.ecs.model.ClusterContainsServicesException;
import com.amazonaws.services.ecs.model.ClusterContainsTasksException;
import com.amazonaws.services.ecs.model.ClusterNotFoundException;
import com.amazonaws.services.ecs.model.CreateClusterRequest;
import com.amazonaws.services.ecs.model.CreateClusterResult;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.CreateServiceResult;
import com.amazonaws.services.ecs.model.DeleteAttributesRequest;
import com.amazonaws.services.ecs.model.DeleteAttributesResult;
import com.amazonaws.services.ecs.model.DeleteClusterRequest;
import com.amazonaws.services.ecs.model.DeleteClusterResult;
import com.amazonaws.services.ecs.model.DeleteServiceRequest;
import com.amazonaws.services.ecs.model.DeleteServiceResult;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeClustersRequest;
import com.amazonaws.services.ecs.model.DescribeClustersResult;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesRequest;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesResult;
import com.amazonaws.services.ecs.model.DescribeServicesRequest;
import com.amazonaws.services.ecs.model.DescribeServicesResult;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.services.ecs.model.DescribeTasksResult;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointRequest;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointResult;
import com.amazonaws.services.ecs.model.InvalidParameterException;
import com.amazonaws.services.ecs.model.ListAttributesRequest;
import com.amazonaws.services.ecs.model.ListAttributesResult;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import com.amazonaws.services.ecs.model.ListClustersResult;
import com.amazonaws.services.ecs.model.ListContainerInstancesRequest;
import com.amazonaws.services.ecs.model.ListContainerInstancesResult;
import com.amazonaws.services.ecs.model.ListServicesRequest;
import com.amazonaws.services.ecs.model.ListServicesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsResult;
import com.amazonaws.services.ecs.model.ListTasksRequest;
import com.amazonaws.services.ecs.model.ListTasksResult;
import com.amazonaws.services.ecs.model.MissingVersionException;
import com.amazonaws.services.ecs.model.NoUpdateAvailableException;
import com.amazonaws.services.ecs.model.PlatformTaskDefinitionIncompatibilityException;
import com.amazonaws.services.ecs.model.PlatformUnknownException;
import com.amazonaws.services.ecs.model.PutAttributesRequest;
import com.amazonaws.services.ecs.model.PutAttributesResult;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.RunTaskResult;
import com.amazonaws.services.ecs.model.ServerException;
import com.amazonaws.services.ecs.model.ServiceNotActiveException;
import com.amazonaws.services.ecs.model.ServiceNotFoundException;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.StartTaskResult;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.services.ecs.model.StopTaskResult;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeResult;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeResult;
import com.amazonaws.services.ecs.model.TargetNotFoundException;
import com.amazonaws.services.ecs.model.UnsupportedFeatureException;
import com.amazonaws.services.ecs.model.UpdateContainerAgentRequest;
import com.amazonaws.services.ecs.model.UpdateContainerAgentResult;
import com.amazonaws.services.ecs.model.UpdateContainerInstancesStateRequest;
import com.amazonaws.services.ecs.model.UpdateContainerInstancesStateResult;
import com.amazonaws.services.ecs.model.UpdateInProgressException;
import com.amazonaws.services.ecs.model.UpdateServiceRequest;
import com.amazonaws.services.ecs.model.UpdateServiceResult;
import com.amazonaws.services.ecs.model.transform.CreateClusterRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.CreateClusterResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.CreateServiceRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.CreateServiceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteAttributesRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteAttributesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteClusterRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteClusterResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteServiceRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteServiceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterContainerInstanceRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterContainerInstanceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterTaskDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeClustersRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeClustersResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeContainerInstancesRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeContainerInstancesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeServicesRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeServicesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTaskDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTasksRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTasksResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DiscoverPollEndpointRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.DiscoverPollEndpointResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListAttributesRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.ListAttributesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListClustersRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.ListClustersResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListContainerInstancesRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.ListContainerInstancesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListServicesRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.ListServicesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionFamiliesRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionFamiliesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionsRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTasksRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTasksResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.PutAttributesRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.PutAttributesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterContainerInstanceRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterContainerInstanceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterTaskDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RunTaskRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.RunTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.StartTaskRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.StartTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.StopTaskRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.StopTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitContainerStateChangeRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitContainerStateChangeResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitTaskStateChangeRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitTaskStateChangeResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateContainerAgentRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateContainerAgentResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateContainerInstancesStateRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateContainerInstancesStateResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateServiceRequestProtocolMarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateServiceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.waiters.AmazonECSWaiters;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonECSClient
extends AmazonWebServiceClient
implements AmazonECS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonECS.class);
    private static final String DEFAULT_SIGNING_NAME = "ecs";
    private volatile AmazonECSWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BlockedException").withModeledClass(BlockedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoUpdateAvailableException").withModeledClass(NoUpdateAvailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterContainsServicesException").withModeledClass(ClusterContainsServicesException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PlatformTaskDefinitionIncompatibilityException").withModeledClass(PlatformTaskDefinitionIncompatibilityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingVersionException").withModeledClass(MissingVersionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedFeatureException").withModeledClass(UnsupportedFeatureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterContainsContainerInstancesException").withModeledClass(ClusterContainsContainerInstancesException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceNotFoundException").withModeledClass(ServiceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AttributeLimitExceededException").withModeledClass(AttributeLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceNotActiveException").withModeledClass(ServiceNotActiveException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterNotFoundException").withModeledClass(ClusterNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerException").withModeledClass(ServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TargetNotFoundException").withModeledClass(TargetNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClientException").withModeledClass(ClientException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PlatformUnknownException").withModeledClass(PlatformUnknownException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UpdateInProgressException").withModeledClass(UpdateInProgressException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClusterContainsTasksException").withModeledClass(ClusterContainsTasksException.class)).withBaseServiceExceptionClass(AmazonECSException.class));

    @Deprecated
    public AmazonECSClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonECSClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonECSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonECSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AmazonECSClientBuilder builder() {
        return AmazonECSClientBuilder.standard();
    }

    AmazonECSClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonECSClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://ecs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ecs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ecs/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateClusterResult createCluster(CreateClusterRequest request) {
        request = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executeCreateCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateClusterResult executeCreateCluster(CreateClusterRequest createClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateClusterRequestProtocolMarshaller(protocolFactory).marshall((CreateClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateClusterResult createClusterResult = (CreateClusterResult)response.getAwsResponse();
            return createClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateClusterResult createCluster() {
        return this.createCluster(new CreateClusterRequest());
    }

    @Override
    public CreateServiceResult createService(CreateServiceRequest request) {
        request = (CreateServiceRequest)this.beforeClientExecution(request);
        return this.executeCreateService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateServiceResult executeCreateService(CreateServiceRequest createServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateServiceRequestProtocolMarshaller(protocolFactory).marshall((CreateServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateServiceResult createServiceResult = (CreateServiceResult)response.getAwsResponse();
            return createServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAttributesResult deleteAttributes(DeleteAttributesRequest request) {
        request = (DeleteAttributesRequest)this.beforeClientExecution(request);
        return this.executeDeleteAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAttributesResult executeDeleteAttributes(DeleteAttributesRequest deleteAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAttributesRequestProtocolMarshaller(protocolFactory).marshall((DeleteAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAttributesResult deleteAttributesResult = (DeleteAttributesResult)response.getAwsResponse();
            return deleteAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest request) {
        request = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executeDeleteCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteClusterResult executeDeleteCluster(DeleteClusterRequest deleteClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteClusterRequestProtocolMarshaller(protocolFactory).marshall((DeleteClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteClusterResult deleteClusterResult = (DeleteClusterResult)response.getAwsResponse();
            return deleteClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteServiceResult deleteService(DeleteServiceRequest request) {
        request = (DeleteServiceRequest)this.beforeClientExecution(request);
        return this.executeDeleteService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteServiceResult executeDeleteService(DeleteServiceRequest deleteServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServiceRequestProtocolMarshaller(protocolFactory).marshall((DeleteServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteServiceResult deleteServiceResult = (DeleteServiceResult)response.getAwsResponse();
            return deleteServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterContainerInstanceResult deregisterContainerInstance(DeregisterContainerInstanceRequest request) {
        request = (DeregisterContainerInstanceRequest)this.beforeClientExecution(request);
        return this.executeDeregisterContainerInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterContainerInstanceResult executeDeregisterContainerInstance(DeregisterContainerInstanceRequest deregisterContainerInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterContainerInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterContainerInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterContainerInstanceRequestProtocolMarshaller(protocolFactory).marshall((DeregisterContainerInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterContainerInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeregisterContainerInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterContainerInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterContainerInstanceResult deregisterContainerInstanceResult = (DeregisterContainerInstanceResult)response.getAwsResponse();
            return deregisterContainerInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterTaskDefinitionResult deregisterTaskDefinition(DeregisterTaskDefinitionRequest request) {
        request = (DeregisterTaskDefinitionRequest)this.beforeClientExecution(request);
        return this.executeDeregisterTaskDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterTaskDefinitionResult executeDeregisterTaskDefinition(DeregisterTaskDefinitionRequest deregisterTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterTaskDefinitionRequestProtocolMarshaller(protocolFactory).marshall((DeregisterTaskDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterTaskDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeregisterTaskDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterTaskDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterTaskDefinitionResult deregisterTaskDefinitionResult = (DeregisterTaskDefinitionResult)response.getAwsResponse();
            return deregisterTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeClustersResult describeClusters(DescribeClustersRequest request) {
        request = (DescribeClustersRequest)this.beforeClientExecution(request);
        return this.executeDescribeClusters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeClustersResult executeDescribeClusters(DescribeClustersRequest describeClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClustersRequestProtocolMarshaller(protocolFactory).marshall((DescribeClustersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeClusters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClustersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeClustersResult describeClustersResult = (DescribeClustersResult)response.getAwsResponse();
            return describeClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeClustersResult describeClusters() {
        return this.describeClusters(new DescribeClustersRequest());
    }

    @Override
    public DescribeContainerInstancesResult describeContainerInstances(DescribeContainerInstancesRequest request) {
        request = (DescribeContainerInstancesRequest)this.beforeClientExecution(request);
        return this.executeDescribeContainerInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeContainerInstancesResult executeDescribeContainerInstances(DescribeContainerInstancesRequest describeContainerInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeContainerInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeContainerInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeContainerInstancesRequestProtocolMarshaller(protocolFactory).marshall((DescribeContainerInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeContainerInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeContainerInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeContainerInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeContainerInstancesResult describeContainerInstancesResult = (DescribeContainerInstancesResult)response.getAwsResponse();
            return describeContainerInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeServicesResult describeServices(DescribeServicesRequest request) {
        request = (DescribeServicesRequest)this.beforeClientExecution(request);
        return this.executeDescribeServices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeServicesResult executeDescribeServices(DescribeServicesRequest describeServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServicesRequestProtocolMarshaller(protocolFactory).marshall((DescribeServicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeServicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeServices");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeServicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeServicesResult describeServicesResult = (DescribeServicesResult)response.getAwsResponse();
            return describeServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTaskDefinitionResult describeTaskDefinition(DescribeTaskDefinitionRequest request) {
        request = (DescribeTaskDefinitionRequest)this.beforeClientExecution(request);
        return this.executeDescribeTaskDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTaskDefinitionResult executeDescribeTaskDefinition(DescribeTaskDefinitionRequest describeTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTaskDefinitionRequestProtocolMarshaller(protocolFactory).marshall((DescribeTaskDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTaskDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTaskDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTaskDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTaskDefinitionResult describeTaskDefinitionResult = (DescribeTaskDefinitionResult)response.getAwsResponse();
            return describeTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTasksResult describeTasks(DescribeTasksRequest request) {
        request = (DescribeTasksRequest)this.beforeClientExecution(request);
        return this.executeDescribeTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTasksResult executeDescribeTasks(DescribeTasksRequest describeTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTasksRequestProtocolMarshaller(protocolFactory).marshall((DescribeTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTasksResult describeTasksResult = (DescribeTasksResult)response.getAwsResponse();
            return describeTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DiscoverPollEndpointResult discoverPollEndpoint(DiscoverPollEndpointRequest request) {
        request = (DiscoverPollEndpointRequest)this.beforeClientExecution(request);
        return this.executeDiscoverPollEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DiscoverPollEndpointResult executeDiscoverPollEndpoint(DiscoverPollEndpointRequest discoverPollEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(discoverPollEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DiscoverPollEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DiscoverPollEndpointRequestProtocolMarshaller(protocolFactory).marshall((DiscoverPollEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)discoverPollEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DiscoverPollEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DiscoverPollEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DiscoverPollEndpointResult discoverPollEndpointResult = (DiscoverPollEndpointResult)response.getAwsResponse();
            return discoverPollEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DiscoverPollEndpointResult discoverPollEndpoint() {
        return this.discoverPollEndpoint(new DiscoverPollEndpointRequest());
    }

    @Override
    public ListAttributesResult listAttributes(ListAttributesRequest request) {
        request = (ListAttributesRequest)this.beforeClientExecution(request);
        return this.executeListAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAttributesResult executeListAttributes(ListAttributesRequest listAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAttributesRequestProtocolMarshaller(protocolFactory).marshall((ListAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAttributesResult listAttributesResult = (ListAttributesResult)response.getAwsResponse();
            return listAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListClustersResult listClusters(ListClustersRequest request) {
        request = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executeListClusters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListClustersResult executeListClusters(ListClustersRequest listClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClustersRequestProtocolMarshaller(protocolFactory).marshall((ListClustersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListClusters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListClustersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListClustersResult listClustersResult = (ListClustersResult)response.getAwsResponse();
            return listClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListClustersResult listClusters() {
        return this.listClusters(new ListClustersRequest());
    }

    @Override
    public ListContainerInstancesResult listContainerInstances(ListContainerInstancesRequest request) {
        request = (ListContainerInstancesRequest)this.beforeClientExecution(request);
        return this.executeListContainerInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListContainerInstancesResult executeListContainerInstances(ListContainerInstancesRequest listContainerInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listContainerInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListContainerInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListContainerInstancesRequestProtocolMarshaller(protocolFactory).marshall((ListContainerInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listContainerInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListContainerInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListContainerInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListContainerInstancesResult listContainerInstancesResult = (ListContainerInstancesResult)response.getAwsResponse();
            return listContainerInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListContainerInstancesResult listContainerInstances() {
        return this.listContainerInstances(new ListContainerInstancesRequest());
    }

    @Override
    public ListServicesResult listServices(ListServicesRequest request) {
        request = (ListServicesRequest)this.beforeClientExecution(request);
        return this.executeListServices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListServicesResult executeListServices(ListServicesRequest listServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServicesRequestProtocolMarshaller(protocolFactory).marshall((ListServicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listServicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListServices");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListServicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListServicesResult listServicesResult = (ListServicesResult)response.getAwsResponse();
            return listServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServicesResult listServices() {
        return this.listServices(new ListServicesRequest());
    }

    @Override
    public ListTaskDefinitionFamiliesResult listTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest request) {
        request = (ListTaskDefinitionFamiliesRequest)this.beforeClientExecution(request);
        return this.executeListTaskDefinitionFamilies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTaskDefinitionFamiliesResult executeListTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTaskDefinitionFamiliesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTaskDefinitionFamiliesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTaskDefinitionFamiliesRequestProtocolMarshaller(protocolFactory).marshall((ListTaskDefinitionFamiliesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTaskDefinitionFamiliesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTaskDefinitionFamilies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTaskDefinitionFamiliesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTaskDefinitionFamiliesResult listTaskDefinitionFamiliesResult = (ListTaskDefinitionFamiliesResult)response.getAwsResponse();
            return listTaskDefinitionFamiliesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTaskDefinitionFamiliesResult listTaskDefinitionFamilies() {
        return this.listTaskDefinitionFamilies(new ListTaskDefinitionFamiliesRequest());
    }

    @Override
    public ListTaskDefinitionsResult listTaskDefinitions(ListTaskDefinitionsRequest request) {
        request = (ListTaskDefinitionsRequest)this.beforeClientExecution(request);
        return this.executeListTaskDefinitions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTaskDefinitionsResult executeListTaskDefinitions(ListTaskDefinitionsRequest listTaskDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTaskDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTaskDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTaskDefinitionsRequestProtocolMarshaller(protocolFactory).marshall((ListTaskDefinitionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTaskDefinitionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTaskDefinitions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTaskDefinitionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTaskDefinitionsResult listTaskDefinitionsResult = (ListTaskDefinitionsResult)response.getAwsResponse();
            return listTaskDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTaskDefinitionsResult listTaskDefinitions() {
        return this.listTaskDefinitions(new ListTaskDefinitionsRequest());
    }

    @Override
    public ListTasksResult listTasks(ListTasksRequest request) {
        request = (ListTasksRequest)this.beforeClientExecution(request);
        return this.executeListTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTasksResult executeListTasks(ListTasksRequest listTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTasksRequestProtocolMarshaller(protocolFactory).marshall((ListTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTasksResult listTasksResult = (ListTasksResult)response.getAwsResponse();
            return listTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTasksResult listTasks() {
        return this.listTasks(new ListTasksRequest());
    }

    @Override
    public PutAttributesResult putAttributes(PutAttributesRequest request) {
        request = (PutAttributesRequest)this.beforeClientExecution(request);
        return this.executePutAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAttributesResult executePutAttributes(PutAttributesRequest putAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAttributesRequestProtocolMarshaller(protocolFactory).marshall((PutAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutAttributesResult putAttributesResult = (PutAttributesResult)response.getAwsResponse();
            return putAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterContainerInstanceResult registerContainerInstance(RegisterContainerInstanceRequest request) {
        request = (RegisterContainerInstanceRequest)this.beforeClientExecution(request);
        return this.executeRegisterContainerInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterContainerInstanceResult executeRegisterContainerInstance(RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerContainerInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterContainerInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterContainerInstanceRequestProtocolMarshaller(protocolFactory).marshall((RegisterContainerInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerContainerInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterContainerInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterContainerInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterContainerInstanceResult registerContainerInstanceResult = (RegisterContainerInstanceResult)response.getAwsResponse();
            return registerContainerInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterTaskDefinitionResult registerTaskDefinition(RegisterTaskDefinitionRequest request) {
        request = (RegisterTaskDefinitionRequest)this.beforeClientExecution(request);
        return this.executeRegisterTaskDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterTaskDefinitionResult executeRegisterTaskDefinition(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterTaskDefinitionRequestProtocolMarshaller(protocolFactory).marshall((RegisterTaskDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerTaskDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterTaskDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterTaskDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterTaskDefinitionResult registerTaskDefinitionResult = (RegisterTaskDefinitionResult)response.getAwsResponse();
            return registerTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RunTaskResult runTask(RunTaskRequest request) {
        request = (RunTaskRequest)this.beforeClientExecution(request);
        return this.executeRunTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RunTaskResult executeRunTask(RunTaskRequest runTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(runTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RunTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RunTaskRequestProtocolMarshaller(protocolFactory).marshall((RunTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)runTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RunTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RunTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RunTaskResult runTaskResult = (RunTaskResult)response.getAwsResponse();
            return runTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartTaskResult startTask(StartTaskRequest request) {
        request = (StartTaskRequest)this.beforeClientExecution(request);
        return this.executeStartTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartTaskResult executeStartTask(StartTaskRequest startTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTaskRequestProtocolMarshaller(protocolFactory).marshall((StartTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartTaskResult startTaskResult = (StartTaskResult)response.getAwsResponse();
            return startTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopTaskResult stopTask(StopTaskRequest request) {
        request = (StopTaskRequest)this.beforeClientExecution(request);
        return this.executeStopTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopTaskResult executeStopTask(StopTaskRequest stopTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopTaskRequestProtocolMarshaller(protocolFactory).marshall((StopTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopTaskResult stopTaskResult = (StopTaskResult)response.getAwsResponse();
            return stopTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SubmitContainerStateChangeResult submitContainerStateChange(SubmitContainerStateChangeRequest request) {
        request = (SubmitContainerStateChangeRequest)this.beforeClientExecution(request);
        return this.executeSubmitContainerStateChange(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SubmitContainerStateChangeResult executeSubmitContainerStateChange(SubmitContainerStateChangeRequest submitContainerStateChangeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(submitContainerStateChangeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubmitContainerStateChangeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubmitContainerStateChangeRequestProtocolMarshaller(protocolFactory).marshall((SubmitContainerStateChangeRequest)super.beforeMarshalling((AmazonWebServiceRequest)submitContainerStateChangeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SubmitContainerStateChange");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SubmitContainerStateChangeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SubmitContainerStateChangeResult submitContainerStateChangeResult = (SubmitContainerStateChangeResult)response.getAwsResponse();
            return submitContainerStateChangeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SubmitContainerStateChangeResult submitContainerStateChange() {
        return this.submitContainerStateChange(new SubmitContainerStateChangeRequest());
    }

    @Override
    public SubmitTaskStateChangeResult submitTaskStateChange(SubmitTaskStateChangeRequest request) {
        request = (SubmitTaskStateChangeRequest)this.beforeClientExecution(request);
        return this.executeSubmitTaskStateChange(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SubmitTaskStateChangeResult executeSubmitTaskStateChange(SubmitTaskStateChangeRequest submitTaskStateChangeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(submitTaskStateChangeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubmitTaskStateChangeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubmitTaskStateChangeRequestProtocolMarshaller(protocolFactory).marshall((SubmitTaskStateChangeRequest)super.beforeMarshalling((AmazonWebServiceRequest)submitTaskStateChangeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SubmitTaskStateChange");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SubmitTaskStateChangeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SubmitTaskStateChangeResult submitTaskStateChangeResult = (SubmitTaskStateChangeResult)response.getAwsResponse();
            return submitTaskStateChangeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateContainerAgentResult updateContainerAgent(UpdateContainerAgentRequest request) {
        request = (UpdateContainerAgentRequest)this.beforeClientExecution(request);
        return this.executeUpdateContainerAgent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateContainerAgentResult executeUpdateContainerAgent(UpdateContainerAgentRequest updateContainerAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateContainerAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateContainerAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateContainerAgentRequestProtocolMarshaller(protocolFactory).marshall((UpdateContainerAgentRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateContainerAgentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateContainerAgent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateContainerAgentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateContainerAgentResult updateContainerAgentResult = (UpdateContainerAgentResult)response.getAwsResponse();
            return updateContainerAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateContainerInstancesStateResult updateContainerInstancesState(UpdateContainerInstancesStateRequest request) {
        request = (UpdateContainerInstancesStateRequest)this.beforeClientExecution(request);
        return this.executeUpdateContainerInstancesState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateContainerInstancesStateResult executeUpdateContainerInstancesState(UpdateContainerInstancesStateRequest updateContainerInstancesStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateContainerInstancesStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateContainerInstancesStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateContainerInstancesStateRequestProtocolMarshaller(protocolFactory).marshall((UpdateContainerInstancesStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateContainerInstancesStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateContainerInstancesState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateContainerInstancesStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateContainerInstancesStateResult updateContainerInstancesStateResult = (UpdateContainerInstancesStateResult)response.getAwsResponse();
            return updateContainerInstancesStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServiceResult updateService(UpdateServiceRequest request) {
        request = (UpdateServiceRequest)this.beforeClientExecution(request);
        return this.executeUpdateService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServiceResult executeUpdateService(UpdateServiceRequest updateServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceRequestProtocolMarshaller(protocolFactory).marshall((UpdateServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ECS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServiceResult updateServiceResult = (UpdateServiceResult)response.getAwsResponse();
            return updateServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonECSWaiters waiters() {
        if (this.waiters == null) {
            AmazonECSClient amazonECSClient = this;
            synchronized (amazonECSClient) {
                if (this.waiters == null) {
                    this.waiters = new AmazonECSWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

