/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Resource;

public class ResourceJsonMarshaller {
    private static ResourceJsonMarshaller instance;

    public void marshall(Resource resource, StructuredJsonGenerator jsonGenerator) {
        if (resource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList stringSetValueList;
            jsonGenerator.writeStartObject();
            if (resource.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(resource.getName());
            }
            if (resource.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(resource.getType());
            }
            if (resource.getDoubleValue() != null) {
                jsonGenerator.writeFieldName("doubleValue").writeValue(resource.getDoubleValue().doubleValue());
            }
            if (resource.getLongValue() != null) {
                jsonGenerator.writeFieldName("longValue").writeValue(resource.getLongValue().longValue());
            }
            if (resource.getIntegerValue() != null) {
                jsonGenerator.writeFieldName("integerValue").writeValue(resource.getIntegerValue().intValue());
            }
            if (!(stringSetValueList = (SdkInternalList)resource.getStringSetValue()).isEmpty() || !stringSetValueList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("stringSetValue");
                jsonGenerator.writeStartArray();
                for (String stringSetValueListValue : stringSetValueList) {
                    if (stringSetValueListValue == null) continue;
                    jsonGenerator.writeValue(stringSetValueListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonMarshaller();
        }
        return instance;
    }
}

