/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.PlacementConstraintType;
import com.amazonaws.services.ecs.model.transform.PlacementConstraintMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class PlacementConstraint
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String expression;

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public PlacementConstraint withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(PlacementConstraintType type) {
        this.withType(type);
    }

    public PlacementConstraint withType(PlacementConstraintType type) {
        this.type = type.toString();
        return this;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public PlacementConstraint withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getExpression() != null) {
            sb.append("Expression: ").append(this.getExpression());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementConstraint)) {
            return false;
        }
        PlacementConstraint other = (PlacementConstraint)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        return other.getExpression() == null || other.getExpression().equals(this.getExpression());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        return hashCode;
    }

    public PlacementConstraint clone() {
        try {
            return (PlacementConstraint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlacementConstraintMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

