/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.LogDriver;
import com.amazonaws.services.ecs.model.transform.LogConfigurationMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LogConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String logDriver;
    private Map<String, String> options;

    public void setLogDriver(String logDriver) {
        this.logDriver = logDriver;
    }

    @JsonProperty(value="logDriver")
    public String getLogDriver() {
        return this.logDriver;
    }

    public LogConfiguration withLogDriver(String logDriver) {
        this.setLogDriver(logDriver);
        return this;
    }

    @JsonIgnore
    public void setLogDriver(LogDriver logDriver) {
        this.withLogDriver(logDriver);
    }

    public LogConfiguration withLogDriver(LogDriver logDriver) {
        this.logDriver = logDriver.toString();
        return this;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public LogConfiguration withOptions(Map<String, String> options) {
        this.setOptions(options);
        return this;
    }

    public LogConfiguration addOptionsEntry(String key, String value) {
        if (null == this.options) {
            this.options = new HashMap<String, String>();
        }
        if (this.options.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.options.put(key, value);
        return this;
    }

    public LogConfiguration clearOptionsEntries() {
        this.options = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogDriver() != null) {
            sb.append("LogDriver: ").append(this.getLogDriver()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        if (other.getLogDriver() == null ^ this.getLogDriver() == null) {
            return false;
        }
        if (other.getLogDriver() != null && !other.getLogDriver().equals(this.getLogDriver())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogDriver() == null ? 0 : this.getLogDriver().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public LogConfiguration clone() {
        try {
            return (LogConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

