/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Deployment;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.Service;
import com.amazonaws.services.ecs.model.ServiceEvent;
import com.amazonaws.services.ecs.model.transform.DeploymentConfigurationJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.DeploymentJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.LoadBalancerJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.ServiceEventJsonMarshaller;

public class ServiceJsonMarshaller {
    private static ServiceJsonMarshaller instance;

    public void marshall(Service service, StructuredJsonGenerator jsonGenerator) {
        if (service == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList eventsList;
            SdkInternalList deploymentsList;
            SdkInternalList loadBalancersList;
            jsonGenerator.writeStartObject();
            if (service.getServiceArn() != null) {
                jsonGenerator.writeFieldName("serviceArn").writeValue(service.getServiceArn());
            }
            if (service.getServiceName() != null) {
                jsonGenerator.writeFieldName("serviceName").writeValue(service.getServiceName());
            }
            if (service.getClusterArn() != null) {
                jsonGenerator.writeFieldName("clusterArn").writeValue(service.getClusterArn());
            }
            if (!(loadBalancersList = (SdkInternalList)service.getLoadBalancers()).isEmpty() || !loadBalancersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("loadBalancers");
                jsonGenerator.writeStartArray();
                for (Object loadBalancersListValue : loadBalancersList) {
                    if (loadBalancersListValue == null) continue;
                    LoadBalancerJsonMarshaller.getInstance().marshall((LoadBalancer)loadBalancersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (service.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(service.getStatus());
            }
            if (service.getDesiredCount() != null) {
                jsonGenerator.writeFieldName("desiredCount").writeValue(service.getDesiredCount().intValue());
            }
            if (service.getRunningCount() != null) {
                jsonGenerator.writeFieldName("runningCount").writeValue(service.getRunningCount().intValue());
            }
            if (service.getPendingCount() != null) {
                jsonGenerator.writeFieldName("pendingCount").writeValue(service.getPendingCount().intValue());
            }
            if (service.getTaskDefinition() != null) {
                jsonGenerator.writeFieldName("taskDefinition").writeValue(service.getTaskDefinition());
            }
            if (service.getDeploymentConfiguration() != null) {
                jsonGenerator.writeFieldName("deploymentConfiguration");
                DeploymentConfigurationJsonMarshaller.getInstance().marshall(service.getDeploymentConfiguration(), jsonGenerator);
            }
            if (!(deploymentsList = (SdkInternalList)service.getDeployments()).isEmpty() || !deploymentsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("deployments");
                jsonGenerator.writeStartArray();
                for (Deployment deploymentsListValue : deploymentsList) {
                    if (deploymentsListValue == null) continue;
                    DeploymentJsonMarshaller.getInstance().marshall(deploymentsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (service.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(service.getRoleArn());
            }
            if (!(eventsList = (SdkInternalList)service.getEvents()).isEmpty() || !eventsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("events");
                jsonGenerator.writeStartArray();
                for (ServiceEvent eventsListValue : eventsList) {
                    if (eventsListValue == null) continue;
                    ServiceEventJsonMarshaller.getInstance().marshall(eventsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (service.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(service.getCreatedAt());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServiceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServiceJsonMarshaller();
        }
        return instance;
    }
}

