/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Failure;
import com.amazonaws.services.ecs.model.Service;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeServicesResult
implements Serializable,
Cloneable {
    private SdkInternalList<Service> services;
    private SdkInternalList<Failure> failures;

    public List<Service> getServices() {
        if (this.services == null) {
            this.services = new SdkInternalList();
        }
        return this.services;
    }

    public void setServices(Collection<Service> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        this.services = new SdkInternalList(services);
    }

    public DescribeServicesResult withServices(Service ... services) {
        if (this.services == null) {
            this.setServices((Collection<Service>)new SdkInternalList(services.length));
        }
        for (Service ele : services) {
            this.services.add((Object)ele);
        }
        return this;
    }

    public DescribeServicesResult withServices(Collection<Service> services) {
        this.setServices(services);
        return this;
    }

    public List<Failure> getFailures() {
        if (this.failures == null) {
            this.failures = new SdkInternalList();
        }
        return this.failures;
    }

    public void setFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        this.failures = new SdkInternalList(failures);
    }

    public DescribeServicesResult withFailures(Failure ... failures) {
        if (this.failures == null) {
            this.setFailures((Collection<Failure>)new SdkInternalList(failures.length));
        }
        for (Failure ele : failures) {
            this.failures.add((Object)ele);
        }
        return this;
    }

    public DescribeServicesResult withFailures(Collection<Failure> failures) {
        this.setFailures(failures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServices() != null) {
            sb.append("Services: " + this.getServices() + ",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: " + this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResult)) {
            return false;
        }
        DescribeServicesResult other = (DescribeServicesResult)obj;
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        if (other.getServices() != null && !other.getServices().equals(this.getServices())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public DescribeServicesResult clone() {
        try {
            return (DescribeServicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

