/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ecs.AmazonECSAsync;
import com.amazonaws.services.ecs.AmazonECSClient;
import com.amazonaws.services.ecs.model.CreateClusterRequest;
import com.amazonaws.services.ecs.model.CreateClusterResult;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.CreateServiceResult;
import com.amazonaws.services.ecs.model.DeleteClusterRequest;
import com.amazonaws.services.ecs.model.DeleteClusterResult;
import com.amazonaws.services.ecs.model.DeleteServiceRequest;
import com.amazonaws.services.ecs.model.DeleteServiceResult;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeClustersRequest;
import com.amazonaws.services.ecs.model.DescribeClustersResult;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesRequest;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesResult;
import com.amazonaws.services.ecs.model.DescribeServicesRequest;
import com.amazonaws.services.ecs.model.DescribeServicesResult;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.services.ecs.model.DescribeTasksResult;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointRequest;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointResult;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import com.amazonaws.services.ecs.model.ListClustersResult;
import com.amazonaws.services.ecs.model.ListContainerInstancesRequest;
import com.amazonaws.services.ecs.model.ListContainerInstancesResult;
import com.amazonaws.services.ecs.model.ListServicesRequest;
import com.amazonaws.services.ecs.model.ListServicesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsResult;
import com.amazonaws.services.ecs.model.ListTasksRequest;
import com.amazonaws.services.ecs.model.ListTasksResult;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.RunTaskResult;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.StartTaskResult;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.services.ecs.model.StopTaskResult;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeResult;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeResult;
import com.amazonaws.services.ecs.model.UpdateContainerAgentRequest;
import com.amazonaws.services.ecs.model.UpdateContainerAgentResult;
import com.amazonaws.services.ecs.model.UpdateServiceRequest;
import com.amazonaws.services.ecs.model.UpdateServiceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonECSAsyncClient
extends AmazonECSClient
implements AmazonECSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonECSAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonECSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonECSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonECSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonECSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(final CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result;
                try {
                    result = AmazonECSAsyncClient.this.createCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync() {
        return this.createClusterAsync(new CreateClusterRequest());
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        return this.createClusterAsync(new CreateClusterRequest(), asyncHandler);
    }

    @Override
    public Future<CreateServiceResult> createServiceAsync(CreateServiceRequest request) {
        return this.createServiceAsync(request, null);
    }

    @Override
    public Future<CreateServiceResult> createServiceAsync(final CreateServiceRequest request, final AsyncHandler<CreateServiceRequest, CreateServiceResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateServiceResult>(){

            @Override
            public CreateServiceResult call() throws Exception {
                CreateServiceResult result;
                try {
                    result = AmazonECSAsyncClient.this.createService(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(final DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result;
                try {
                    result = AmazonECSAsyncClient.this.deleteCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteServiceResult> deleteServiceAsync(DeleteServiceRequest request) {
        return this.deleteServiceAsync(request, null);
    }

    @Override
    public Future<DeleteServiceResult> deleteServiceAsync(final DeleteServiceRequest request, final AsyncHandler<DeleteServiceRequest, DeleteServiceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteServiceResult>(){

            @Override
            public DeleteServiceResult call() throws Exception {
                DeleteServiceResult result;
                try {
                    result = AmazonECSAsyncClient.this.deleteService(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterContainerInstanceResult> deregisterContainerInstanceAsync(DeregisterContainerInstanceRequest request) {
        return this.deregisterContainerInstanceAsync(request, null);
    }

    @Override
    public Future<DeregisterContainerInstanceResult> deregisterContainerInstanceAsync(final DeregisterContainerInstanceRequest request, final AsyncHandler<DeregisterContainerInstanceRequest, DeregisterContainerInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeregisterContainerInstanceResult>(){

            @Override
            public DeregisterContainerInstanceResult call() throws Exception {
                DeregisterContainerInstanceResult result;
                try {
                    result = AmazonECSAsyncClient.this.deregisterContainerInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterTaskDefinitionResult> deregisterTaskDefinitionAsync(DeregisterTaskDefinitionRequest request) {
        return this.deregisterTaskDefinitionAsync(request, null);
    }

    @Override
    public Future<DeregisterTaskDefinitionResult> deregisterTaskDefinitionAsync(final DeregisterTaskDefinitionRequest request, final AsyncHandler<DeregisterTaskDefinitionRequest, DeregisterTaskDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeregisterTaskDefinitionResult>(){

            @Override
            public DeregisterTaskDefinitionResult call() throws Exception {
                DeregisterTaskDefinitionResult result;
                try {
                    result = AmazonECSAsyncClient.this.deregisterTaskDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request) {
        return this.describeClustersAsync(request, null);
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(final DescribeClustersRequest request, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeClusters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync() {
        return this.describeClustersAsync(new DescribeClustersRequest());
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        return this.describeClustersAsync(new DescribeClustersRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeContainerInstancesResult> describeContainerInstancesAsync(DescribeContainerInstancesRequest request) {
        return this.describeContainerInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeContainerInstancesResult> describeContainerInstancesAsync(final DescribeContainerInstancesRequest request, final AsyncHandler<DescribeContainerInstancesRequest, DescribeContainerInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeContainerInstancesResult>(){

            @Override
            public DescribeContainerInstancesResult call() throws Exception {
                DescribeContainerInstancesResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeContainerInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request) {
        return this.describeServicesAsync(request, null);
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(final DescribeServicesRequest request, final AsyncHandler<DescribeServicesRequest, DescribeServicesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                DescribeServicesResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeServices(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTaskDefinitionResult> describeTaskDefinitionAsync(DescribeTaskDefinitionRequest request) {
        return this.describeTaskDefinitionAsync(request, null);
    }

    @Override
    public Future<DescribeTaskDefinitionResult> describeTaskDefinitionAsync(final DescribeTaskDefinitionRequest request, final AsyncHandler<DescribeTaskDefinitionRequest, DescribeTaskDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTaskDefinitionResult>(){

            @Override
            public DescribeTaskDefinitionResult call() throws Exception {
                DescribeTaskDefinitionResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeTaskDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTasksResult> describeTasksAsync(DescribeTasksRequest request) {
        return this.describeTasksAsync(request, null);
    }

    @Override
    public Future<DescribeTasksResult> describeTasksAsync(final DescribeTasksRequest request, final AsyncHandler<DescribeTasksRequest, DescribeTasksResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTasksResult>(){

            @Override
            public DescribeTasksResult call() throws Exception {
                DescribeTasksResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeTasks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync(DiscoverPollEndpointRequest request) {
        return this.discoverPollEndpointAsync(request, null);
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync(final DiscoverPollEndpointRequest request, final AsyncHandler<DiscoverPollEndpointRequest, DiscoverPollEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<DiscoverPollEndpointResult>(){

            @Override
            public DiscoverPollEndpointResult call() throws Exception {
                DiscoverPollEndpointResult result;
                try {
                    result = AmazonECSAsyncClient.this.discoverPollEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync() {
        return this.discoverPollEndpointAsync(new DiscoverPollEndpointRequest());
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync(AsyncHandler<DiscoverPollEndpointRequest, DiscoverPollEndpointResult> asyncHandler) {
        return this.discoverPollEndpointAsync(new DiscoverPollEndpointRequest(), asyncHandler);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(final ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result;
                try {
                    result = AmazonECSAsyncClient.this.listClusters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync() {
        return this.listClustersAsync(new ListClustersRequest());
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        return this.listClustersAsync(new ListClustersRequest(), asyncHandler);
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync(ListContainerInstancesRequest request) {
        return this.listContainerInstancesAsync(request, null);
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync(final ListContainerInstancesRequest request, final AsyncHandler<ListContainerInstancesRequest, ListContainerInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListContainerInstancesResult>(){

            @Override
            public ListContainerInstancesResult call() throws Exception {
                ListContainerInstancesResult result;
                try {
                    result = AmazonECSAsyncClient.this.listContainerInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync() {
        return this.listContainerInstancesAsync(new ListContainerInstancesRequest());
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync(AsyncHandler<ListContainerInstancesRequest, ListContainerInstancesResult> asyncHandler) {
        return this.listContainerInstancesAsync(new ListContainerInstancesRequest(), asyncHandler);
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(ListServicesRequest request) {
        return this.listServicesAsync(request, null);
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(final ListServicesRequest request, final AsyncHandler<ListServicesRequest, ListServicesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListServicesResult>(){

            @Override
            public ListServicesResult call() throws Exception {
                ListServicesResult result;
                try {
                    result = AmazonECSAsyncClient.this.listServices(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListServicesResult> listServicesAsync() {
        return this.listServicesAsync(new ListServicesRequest());
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(AsyncHandler<ListServicesRequest, ListServicesResult> asyncHandler) {
        return this.listServicesAsync(new ListServicesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync(ListTaskDefinitionFamiliesRequest request) {
        return this.listTaskDefinitionFamiliesAsync(request, null);
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync(final ListTaskDefinitionFamiliesRequest request, final AsyncHandler<ListTaskDefinitionFamiliesRequest, ListTaskDefinitionFamiliesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTaskDefinitionFamiliesResult>(){

            @Override
            public ListTaskDefinitionFamiliesResult call() throws Exception {
                ListTaskDefinitionFamiliesResult result;
                try {
                    result = AmazonECSAsyncClient.this.listTaskDefinitionFamilies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync() {
        return this.listTaskDefinitionFamiliesAsync(new ListTaskDefinitionFamiliesRequest());
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync(AsyncHandler<ListTaskDefinitionFamiliesRequest, ListTaskDefinitionFamiliesResult> asyncHandler) {
        return this.listTaskDefinitionFamiliesAsync(new ListTaskDefinitionFamiliesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync(ListTaskDefinitionsRequest request) {
        return this.listTaskDefinitionsAsync(request, null);
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync(final ListTaskDefinitionsRequest request, final AsyncHandler<ListTaskDefinitionsRequest, ListTaskDefinitionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTaskDefinitionsResult>(){

            @Override
            public ListTaskDefinitionsResult call() throws Exception {
                ListTaskDefinitionsResult result;
                try {
                    result = AmazonECSAsyncClient.this.listTaskDefinitions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync() {
        return this.listTaskDefinitionsAsync(new ListTaskDefinitionsRequest());
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync(AsyncHandler<ListTaskDefinitionsRequest, ListTaskDefinitionsResult> asyncHandler) {
        return this.listTaskDefinitionsAsync(new ListTaskDefinitionsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(ListTasksRequest request) {
        return this.listTasksAsync(request, null);
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(final ListTasksRequest request, final AsyncHandler<ListTasksRequest, ListTasksResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTasksResult>(){

            @Override
            public ListTasksResult call() throws Exception {
                ListTasksResult result;
                try {
                    result = AmazonECSAsyncClient.this.listTasks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTasksResult> listTasksAsync() {
        return this.listTasksAsync(new ListTasksRequest());
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(AsyncHandler<ListTasksRequest, ListTasksResult> asyncHandler) {
        return this.listTasksAsync(new ListTasksRequest(), asyncHandler);
    }

    @Override
    public Future<RegisterContainerInstanceResult> registerContainerInstanceAsync(RegisterContainerInstanceRequest request) {
        return this.registerContainerInstanceAsync(request, null);
    }

    @Override
    public Future<RegisterContainerInstanceResult> registerContainerInstanceAsync(final RegisterContainerInstanceRequest request, final AsyncHandler<RegisterContainerInstanceRequest, RegisterContainerInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterContainerInstanceResult>(){

            @Override
            public RegisterContainerInstanceResult call() throws Exception {
                RegisterContainerInstanceResult result;
                try {
                    result = AmazonECSAsyncClient.this.registerContainerInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterTaskDefinitionResult> registerTaskDefinitionAsync(RegisterTaskDefinitionRequest request) {
        return this.registerTaskDefinitionAsync(request, null);
    }

    @Override
    public Future<RegisterTaskDefinitionResult> registerTaskDefinitionAsync(final RegisterTaskDefinitionRequest request, final AsyncHandler<RegisterTaskDefinitionRequest, RegisterTaskDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterTaskDefinitionResult>(){

            @Override
            public RegisterTaskDefinitionResult call() throws Exception {
                RegisterTaskDefinitionResult result;
                try {
                    result = AmazonECSAsyncClient.this.registerTaskDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RunTaskResult> runTaskAsync(RunTaskRequest request) {
        return this.runTaskAsync(request, null);
    }

    @Override
    public Future<RunTaskResult> runTaskAsync(final RunTaskRequest request, final AsyncHandler<RunTaskRequest, RunTaskResult> asyncHandler) {
        return this.executorService.submit(new Callable<RunTaskResult>(){

            @Override
            public RunTaskResult call() throws Exception {
                RunTaskResult result;
                try {
                    result = AmazonECSAsyncClient.this.runTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTaskResult> startTaskAsync(StartTaskRequest request) {
        return this.startTaskAsync(request, null);
    }

    @Override
    public Future<StartTaskResult> startTaskAsync(final StartTaskRequest request, final AsyncHandler<StartTaskRequest, StartTaskResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartTaskResult>(){

            @Override
            public StartTaskResult call() throws Exception {
                StartTaskResult result;
                try {
                    result = AmazonECSAsyncClient.this.startTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopTaskResult> stopTaskAsync(StopTaskRequest request) {
        return this.stopTaskAsync(request, null);
    }

    @Override
    public Future<StopTaskResult> stopTaskAsync(final StopTaskRequest request, final AsyncHandler<StopTaskRequest, StopTaskResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopTaskResult>(){

            @Override
            public StopTaskResult call() throws Exception {
                StopTaskResult result;
                try {
                    result = AmazonECSAsyncClient.this.stopTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync(SubmitContainerStateChangeRequest request) {
        return this.submitContainerStateChangeAsync(request, null);
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync(final SubmitContainerStateChangeRequest request, final AsyncHandler<SubmitContainerStateChangeRequest, SubmitContainerStateChangeResult> asyncHandler) {
        return this.executorService.submit(new Callable<SubmitContainerStateChangeResult>(){

            @Override
            public SubmitContainerStateChangeResult call() throws Exception {
                SubmitContainerStateChangeResult result;
                try {
                    result = AmazonECSAsyncClient.this.submitContainerStateChange(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync() {
        return this.submitContainerStateChangeAsync(new SubmitContainerStateChangeRequest());
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync(AsyncHandler<SubmitContainerStateChangeRequest, SubmitContainerStateChangeResult> asyncHandler) {
        return this.submitContainerStateChangeAsync(new SubmitContainerStateChangeRequest(), asyncHandler);
    }

    @Override
    public Future<SubmitTaskStateChangeResult> submitTaskStateChangeAsync(SubmitTaskStateChangeRequest request) {
        return this.submitTaskStateChangeAsync(request, null);
    }

    @Override
    public Future<SubmitTaskStateChangeResult> submitTaskStateChangeAsync(final SubmitTaskStateChangeRequest request, final AsyncHandler<SubmitTaskStateChangeRequest, SubmitTaskStateChangeResult> asyncHandler) {
        return this.executorService.submit(new Callable<SubmitTaskStateChangeResult>(){

            @Override
            public SubmitTaskStateChangeResult call() throws Exception {
                SubmitTaskStateChangeResult result;
                try {
                    result = AmazonECSAsyncClient.this.submitTaskStateChange(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContainerAgentResult> updateContainerAgentAsync(UpdateContainerAgentRequest request) {
        return this.updateContainerAgentAsync(request, null);
    }

    @Override
    public Future<UpdateContainerAgentResult> updateContainerAgentAsync(final UpdateContainerAgentRequest request, final AsyncHandler<UpdateContainerAgentRequest, UpdateContainerAgentResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateContainerAgentResult>(){

            @Override
            public UpdateContainerAgentResult call() throws Exception {
                UpdateContainerAgentResult result;
                try {
                    result = AmazonECSAsyncClient.this.updateContainerAgent(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServiceResult> updateServiceAsync(UpdateServiceRequest request) {
        return this.updateServiceAsync(request, null);
    }

    @Override
    public Future<UpdateServiceResult> updateServiceAsync(final UpdateServiceRequest request, final AsyncHandler<UpdateServiceRequest, UpdateServiceResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateServiceResult>(){

            @Override
            public UpdateServiceResult call() throws Exception {
                UpdateServiceResult result;
                try {
                    result = AmazonECSAsyncClient.this.updateService(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

