/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class StopTaskRequestMarshaller
implements Marshaller<Request<StopTaskRequest>, StopTaskRequest> {
    public Request<StopTaskRequest> marshall(StopTaskRequest stopTaskRequest) {
        if (stopTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)stopTaskRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.StopTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (stopTaskRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(stopTaskRequest.getCluster());
            }
            if (stopTaskRequest.getTask() != null) {
                jsonGenerator.writeFieldName("task").writeValue(stopTaskRequest.getTask());
            }
            if (stopTaskRequest.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(stopTaskRequest.getReason());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

