/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.MountPoint;
import com.amazonaws.util.json.JSONWriter;

public class MountPointJsonMarshaller {
    private static MountPointJsonMarshaller instance;

    public void marshall(MountPoint mountPoint, JSONWriter jsonWriter) {
        if (mountPoint == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (mountPoint.getSourceVolume() != null) {
                jsonWriter.key("sourceVolume").value((Object)mountPoint.getSourceVolume());
            }
            if (mountPoint.getContainerPath() != null) {
                jsonWriter.key("containerPath").value((Object)mountPoint.getContainerPath());
            }
            if (mountPoint.getReadOnly() != null) {
                jsonWriter.key("readOnly").value((Object)mountPoint.getReadOnly());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MountPointJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MountPointJsonMarshaller();
        }
        return instance;
    }
}

