/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.transform.TaskOverrideJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class StartTaskRequestMarshaller
implements Marshaller<Request<StartTaskRequest>, StartTaskRequest> {
    public Request<StartTaskRequest> marshall(StartTaskRequest startTaskRequest) {
        if (startTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startTaskRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.StartTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList containerInstancesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (startTaskRequest.getCluster() != null) {
                jsonWriter.key("cluster").value((Object)startTaskRequest.getCluster());
            }
            if (startTaskRequest.getTaskDefinition() != null) {
                jsonWriter.key("taskDefinition").value((Object)startTaskRequest.getTaskDefinition());
            }
            if (startTaskRequest.getOverrides() != null) {
                jsonWriter.key("overrides");
                TaskOverrideJsonMarshaller.getInstance().marshall(startTaskRequest.getOverrides(), jsonWriter);
            }
            if (!(containerInstancesList = (SdkInternalList)startTaskRequest.getContainerInstances()).isEmpty() || !containerInstancesList.isAutoConstruct()) {
                jsonWriter.key("containerInstances");
                jsonWriter.array();
                for (String containerInstancesListValue : containerInstancesList) {
                    if (containerInstancesListValue == null) continue;
                    jsonWriter.value((Object)containerInstancesListValue);
                }
                jsonWriter.endArray();
            }
            if (startTaskRequest.getStartedBy() != null) {
                jsonWriter.key("startedBy").value((Object)startTaskRequest.getStartedBy());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

