/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.util.json.JSONWriter;

public class ResourceJsonMarshaller {
    private static ResourceJsonMarshaller instance;

    public void marshall(Resource resource, JSONWriter jsonWriter) {
        if (resource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList stringSetValueList;
            jsonWriter.object();
            if (resource.getName() != null) {
                jsonWriter.key("name").value((Object)resource.getName());
            }
            if (resource.getType() != null) {
                jsonWriter.key("type").value((Object)resource.getType());
            }
            if (resource.getDoubleValue() != null) {
                jsonWriter.key("doubleValue").value((Object)resource.getDoubleValue());
            }
            if (resource.getLongValue() != null) {
                jsonWriter.key("longValue").value((Object)resource.getLongValue());
            }
            if (resource.getIntegerValue() != null) {
                jsonWriter.key("integerValue").value((Object)resource.getIntegerValue());
            }
            if (!(stringSetValueList = (SdkInternalList)resource.getStringSetValue()).isEmpty() || !stringSetValueList.isAutoConstruct()) {
                jsonWriter.key("stringSetValue");
                jsonWriter.array();
                for (String stringSetValueListValue : stringSetValueList) {
                    if (stringSetValueListValue == null) continue;
                    jsonWriter.value((Object)stringSetValueListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonMarshaller();
        }
        return instance;
    }
}

