/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.model.CreateClusterRequest;
import com.amazonaws.services.ecs.model.CreateClusterResult;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.CreateServiceResult;
import com.amazonaws.services.ecs.model.DeleteClusterRequest;
import com.amazonaws.services.ecs.model.DeleteClusterResult;
import com.amazonaws.services.ecs.model.DeleteServiceRequest;
import com.amazonaws.services.ecs.model.DeleteServiceResult;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeClustersRequest;
import com.amazonaws.services.ecs.model.DescribeClustersResult;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesRequest;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesResult;
import com.amazonaws.services.ecs.model.DescribeServicesRequest;
import com.amazonaws.services.ecs.model.DescribeServicesResult;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.services.ecs.model.DescribeTasksResult;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointRequest;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointResult;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import com.amazonaws.services.ecs.model.ListClustersResult;
import com.amazonaws.services.ecs.model.ListContainerInstancesRequest;
import com.amazonaws.services.ecs.model.ListContainerInstancesResult;
import com.amazonaws.services.ecs.model.ListServicesRequest;
import com.amazonaws.services.ecs.model.ListServicesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsResult;
import com.amazonaws.services.ecs.model.ListTasksRequest;
import com.amazonaws.services.ecs.model.ListTasksResult;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.RunTaskResult;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.StartTaskResult;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.services.ecs.model.StopTaskResult;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeResult;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeResult;
import com.amazonaws.services.ecs.model.UpdateContainerAgentRequest;
import com.amazonaws.services.ecs.model.UpdateContainerAgentResult;
import com.amazonaws.services.ecs.model.UpdateServiceRequest;
import com.amazonaws.services.ecs.model.UpdateServiceResult;
import com.amazonaws.services.ecs.model.transform.ClientExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ClusterContainsContainerInstancesExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ClusterContainsServicesExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ClusterNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.CreateClusterRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.CreateClusterResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.CreateServiceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.CreateServiceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteClusterRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteClusterResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteServiceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteServiceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterContainerInstanceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterContainerInstanceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterTaskDefinitionRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeClustersRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeClustersResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeContainerInstancesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeContainerInstancesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeServicesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeServicesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTaskDefinitionRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTasksRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTasksResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DiscoverPollEndpointRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DiscoverPollEndpointResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListClustersRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListClustersResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListContainerInstancesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListContainerInstancesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListServicesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListServicesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionFamiliesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionFamiliesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionsRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTasksRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTasksResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.MissingVersionExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.NoUpdateAvailableExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterContainerInstanceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterContainerInstanceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterTaskDefinitionRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RunTaskRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.RunTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ServerExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ServiceNotActiveExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ServiceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.StartTaskRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.StartTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.StopTaskRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.StopTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitContainerStateChangeRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitContainerStateChangeResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitTaskStateChangeRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitTaskStateChangeResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateContainerAgentRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateContainerAgentResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateInProgressExceptionUnmarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateServiceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateServiceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonECSClient
extends AmazonWebServiceClient
implements AmazonECS {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonECS.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonECSClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonECSClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonECSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonECSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonECSClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonECSClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ClusterContainsContainerInstancesExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ServerExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MissingVersionExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ClusterContainsServicesExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ServiceNotActiveExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ClientExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UpdateInProgressExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ClusterNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NoUpdateAvailableExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ServiceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("ecs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ecs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ecs/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteClusterRequestMarshaller().marshall((DeleteClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteClusterResultJsonUnmarshaller unmarshaller = new DeleteClusterResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteClusterResult deleteClusterResult = (DeleteClusterResult)response.getAwsResponse();
            return deleteClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitContainerStateChangeResult submitContainerStateChange(SubmitContainerStateChangeRequest submitContainerStateChangeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(submitContainerStateChangeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubmitContainerStateChangeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubmitContainerStateChangeRequestMarshaller().marshall((SubmitContainerStateChangeRequest)super.beforeMarshalling((AmazonWebServiceRequest)submitContainerStateChangeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SubmitContainerStateChangeResultJsonUnmarshaller unmarshaller = new SubmitContainerStateChangeResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SubmitContainerStateChangeResult submitContainerStateChangeResult = (SubmitContainerStateChangeResult)response.getAwsResponse();
            return submitContainerStateChangeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceResult deleteService(DeleteServiceRequest deleteServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServiceRequestMarshaller().marshall((DeleteServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteServiceResultJsonUnmarshaller unmarshaller = new DeleteServiceResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteServiceResult deleteServiceResult = (DeleteServiceResult)response.getAwsResponse();
            return deleteServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaskDefinitionsResult listTaskDefinitions(ListTaskDefinitionsRequest listTaskDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTaskDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTaskDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTaskDefinitionsRequestMarshaller().marshall((ListTaskDefinitionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTaskDefinitionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListTaskDefinitionsResultJsonUnmarshaller unmarshaller = new ListTaskDefinitionsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListTaskDefinitionsResult listTaskDefinitionsResult = (ListTaskDefinitionsResult)response.getAwsResponse();
            return listTaskDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunTaskResult runTask(RunTaskRequest runTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(runTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RunTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RunTaskRequestMarshaller().marshall((RunTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)runTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RunTaskResultJsonUnmarshaller unmarshaller = new RunTaskResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RunTaskResult runTaskResult = (RunTaskResult)response.getAwsResponse();
            return runTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResult listClusters(ListClustersRequest listClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClustersRequestMarshaller().marshall((ListClustersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListClustersResultJsonUnmarshaller unmarshaller = new ListClustersResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListClustersResult listClustersResult = (ListClustersResult)response.getAwsResponse();
            return listClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResult createCluster(CreateClusterRequest createClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateClusterRequestMarshaller().marshall((CreateClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateClusterResultJsonUnmarshaller unmarshaller = new CreateClusterResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateClusterResult createClusterResult = (CreateClusterResult)response.getAwsResponse();
            return createClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClustersResult describeClusters(DescribeClustersRequest describeClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClustersRequestMarshaller().marshall((DescribeClustersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeClustersResultJsonUnmarshaller unmarshaller = new DescribeClustersResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeClustersResult describeClustersResult = (DescribeClustersResult)response.getAwsResponse();
            return describeClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterContainerInstanceResult deregisterContainerInstance(DeregisterContainerInstanceRequest deregisterContainerInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterContainerInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterContainerInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterContainerInstanceRequestMarshaller().marshall((DeregisterContainerInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterContainerInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeregisterContainerInstanceResultJsonUnmarshaller unmarshaller = new DeregisterContainerInstanceResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeregisterContainerInstanceResult deregisterContainerInstanceResult = (DeregisterContainerInstanceResult)response.getAwsResponse();
            return deregisterContainerInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContainerInstancesResult listContainerInstances(ListContainerInstancesRequest listContainerInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listContainerInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListContainerInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListContainerInstancesRequestMarshaller().marshall((ListContainerInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listContainerInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListContainerInstancesResultJsonUnmarshaller unmarshaller = new ListContainerInstancesResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListContainerInstancesResult listContainerInstancesResult = (ListContainerInstancesResult)response.getAwsResponse();
            return listContainerInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterTaskDefinitionResult deregisterTaskDefinition(DeregisterTaskDefinitionRequest deregisterTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterTaskDefinitionRequestMarshaller().marshall((DeregisterTaskDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterTaskDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeregisterTaskDefinitionResultJsonUnmarshaller unmarshaller = new DeregisterTaskDefinitionResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeregisterTaskDefinitionResult deregisterTaskDefinitionResult = (DeregisterTaskDefinitionResult)response.getAwsResponse();
            return deregisterTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContainerAgentResult updateContainerAgent(UpdateContainerAgentRequest updateContainerAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateContainerAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateContainerAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateContainerAgentRequestMarshaller().marshall((UpdateContainerAgentRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateContainerAgentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateContainerAgentResultJsonUnmarshaller unmarshaller = new UpdateContainerAgentResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateContainerAgentResult updateContainerAgentResult = (UpdateContainerAgentResult)response.getAwsResponse();
            return updateContainerAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTaskDefinitionResult describeTaskDefinition(DescribeTaskDefinitionRequest describeTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTaskDefinitionRequestMarshaller().marshall((DescribeTaskDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTaskDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeTaskDefinitionResultJsonUnmarshaller unmarshaller = new DescribeTaskDefinitionResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeTaskDefinitionResult describeTaskDefinitionResult = (DescribeTaskDefinitionResult)response.getAwsResponse();
            return describeTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterTaskDefinitionResult registerTaskDefinition(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterTaskDefinitionRequestMarshaller().marshall((RegisterTaskDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerTaskDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RegisterTaskDefinitionResultJsonUnmarshaller unmarshaller = new RegisterTaskDefinitionResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RegisterTaskDefinitionResult registerTaskDefinitionResult = (RegisterTaskDefinitionResult)response.getAwsResponse();
            return registerTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitTaskStateChangeResult submitTaskStateChange(SubmitTaskStateChangeRequest submitTaskStateChangeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(submitTaskStateChangeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubmitTaskStateChangeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubmitTaskStateChangeRequestMarshaller().marshall((SubmitTaskStateChangeRequest)super.beforeMarshalling((AmazonWebServiceRequest)submitTaskStateChangeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SubmitTaskStateChangeResultJsonUnmarshaller unmarshaller = new SubmitTaskStateChangeResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SubmitTaskStateChangeResult submitTaskStateChangeResult = (SubmitTaskStateChangeResult)response.getAwsResponse();
            return submitTaskStateChangeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContainerInstancesResult describeContainerInstances(DescribeContainerInstancesRequest describeContainerInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeContainerInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeContainerInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeContainerInstancesRequestMarshaller().marshall((DescribeContainerInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeContainerInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeContainerInstancesResultJsonUnmarshaller unmarshaller = new DescribeContainerInstancesResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeContainerInstancesResult describeContainerInstancesResult = (DescribeContainerInstancesResult)response.getAwsResponse();
            return describeContainerInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterContainerInstanceResult registerContainerInstance(RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerContainerInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterContainerInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterContainerInstanceRequestMarshaller().marshall((RegisterContainerInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerContainerInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RegisterContainerInstanceResultJsonUnmarshaller unmarshaller = new RegisterContainerInstanceResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RegisterContainerInstanceResult registerContainerInstanceResult = (RegisterContainerInstanceResult)response.getAwsResponse();
            return registerContainerInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServicesResult describeServices(DescribeServicesRequest describeServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServicesRequestMarshaller().marshall((DescribeServicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeServicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeServicesResultJsonUnmarshaller unmarshaller = new DescribeServicesResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeServicesResult describeServicesResult = (DescribeServicesResult)response.getAwsResponse();
            return describeServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceResult createService(CreateServiceRequest createServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateServiceRequestMarshaller().marshall((CreateServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateServiceResultJsonUnmarshaller unmarshaller = new CreateServiceResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateServiceResult createServiceResult = (CreateServiceResult)response.getAwsResponse();
            return createServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesResult listServices(ListServicesRequest listServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServicesRequestMarshaller().marshall((ListServicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listServicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListServicesResultJsonUnmarshaller unmarshaller = new ListServicesResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListServicesResult listServicesResult = (ListServicesResult)response.getAwsResponse();
            return listServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceResult updateService(UpdateServiceRequest updateServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceRequestMarshaller().marshall((UpdateServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateServiceResultJsonUnmarshaller unmarshaller = new UpdateServiceResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateServiceResult updateServiceResult = (UpdateServiceResult)response.getAwsResponse();
            return updateServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaskDefinitionFamiliesResult listTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTaskDefinitionFamiliesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTaskDefinitionFamiliesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTaskDefinitionFamiliesRequestMarshaller().marshall((ListTaskDefinitionFamiliesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTaskDefinitionFamiliesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListTaskDefinitionFamiliesResultJsonUnmarshaller unmarshaller = new ListTaskDefinitionFamiliesResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListTaskDefinitionFamiliesResult listTaskDefinitionFamiliesResult = (ListTaskDefinitionFamiliesResult)response.getAwsResponse();
            return listTaskDefinitionFamiliesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTasksResult describeTasks(DescribeTasksRequest describeTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTasksRequestMarshaller().marshall((DescribeTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeTasksResultJsonUnmarshaller unmarshaller = new DescribeTasksResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeTasksResult describeTasksResult = (DescribeTasksResult)response.getAwsResponse();
            return describeTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoverPollEndpointResult discoverPollEndpoint(DiscoverPollEndpointRequest discoverPollEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(discoverPollEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DiscoverPollEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DiscoverPollEndpointRequestMarshaller().marshall((DiscoverPollEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)discoverPollEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DiscoverPollEndpointResultJsonUnmarshaller unmarshaller = new DiscoverPollEndpointResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DiscoverPollEndpointResult discoverPollEndpointResult = (DiscoverPollEndpointResult)response.getAwsResponse();
            return discoverPollEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTaskResult startTask(StartTaskRequest startTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTaskRequestMarshaller().marshall((StartTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StartTaskResultJsonUnmarshaller unmarshaller = new StartTaskResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            StartTaskResult startTaskResult = (StartTaskResult)response.getAwsResponse();
            return startTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTasksResult listTasks(ListTasksRequest listTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTasksRequestMarshaller().marshall((ListTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListTasksResultJsonUnmarshaller unmarshaller = new ListTasksResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListTasksResult listTasksResult = (ListTasksResult)response.getAwsResponse();
            return listTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTaskResult stopTask(StopTaskRequest stopTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopTaskRequestMarshaller().marshall((StopTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StopTaskResultJsonUnmarshaller unmarshaller = new StopTaskResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            StopTaskResult stopTaskResult = (StopTaskResult)response.getAwsResponse();
            return stopTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public SubmitContainerStateChangeResult submitContainerStateChange() throws AmazonServiceException, AmazonClientException {
        return this.submitContainerStateChange(new SubmitContainerStateChangeRequest());
    }

    @Override
    public ListTaskDefinitionsResult listTaskDefinitions() throws AmazonServiceException, AmazonClientException {
        return this.listTaskDefinitions(new ListTaskDefinitionsRequest());
    }

    @Override
    public ListClustersResult listClusters() throws AmazonServiceException, AmazonClientException {
        return this.listClusters(new ListClustersRequest());
    }

    @Override
    public CreateClusterResult createCluster() throws AmazonServiceException, AmazonClientException {
        return this.createCluster(new CreateClusterRequest());
    }

    @Override
    public DescribeClustersResult describeClusters() throws AmazonServiceException, AmazonClientException {
        return this.describeClusters(new DescribeClustersRequest());
    }

    @Override
    public ListContainerInstancesResult listContainerInstances() throws AmazonServiceException, AmazonClientException {
        return this.listContainerInstances(new ListContainerInstancesRequest());
    }

    @Override
    public ListServicesResult listServices() throws AmazonServiceException, AmazonClientException {
        return this.listServices(new ListServicesRequest());
    }

    @Override
    public ListTaskDefinitionFamiliesResult listTaskDefinitionFamilies() throws AmazonServiceException, AmazonClientException {
        return this.listTaskDefinitionFamilies(new ListTaskDefinitionFamiliesRequest());
    }

    @Override
    public DiscoverPollEndpointResult discoverPollEndpoint() throws AmazonServiceException, AmazonClientException {
        return this.discoverPollEndpoint(new DiscoverPollEndpointRequest());
    }

    @Override
    public ListTasksResult listTasks() throws AmazonServiceException, AmazonClientException {
        return this.listTasks(new ListTasksRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        return result;
    }
}

