/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.VersionInfo;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class RegisterContainerInstanceRequestMarshaller
implements Marshaller<Request<RegisterContainerInstanceRequest>, RegisterContainerInstanceRequest> {
    public Request<RegisterContainerInstanceRequest> marshall(RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        if (registerContainerInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerContainerInstanceRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.RegisterContainerInstance";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            VersionInfo versionInfo;
            ListWithAutoConstructFlag totalResourcesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (registerContainerInstanceRequest.getCluster() != null) {
                jsonWriter.key("cluster").value((Object)registerContainerInstanceRequest.getCluster());
            }
            if (registerContainerInstanceRequest.getInstanceIdentityDocument() != null) {
                jsonWriter.key("instanceIdentityDocument").value((Object)registerContainerInstanceRequest.getInstanceIdentityDocument());
            }
            if (registerContainerInstanceRequest.getInstanceIdentityDocumentSignature() != null) {
                jsonWriter.key("instanceIdentityDocumentSignature").value((Object)registerContainerInstanceRequest.getInstanceIdentityDocumentSignature());
            }
            if (!((totalResourcesList = (ListWithAutoConstructFlag)registerContainerInstanceRequest.getTotalResources()) == null || totalResourcesList.isAutoConstruct() && totalResourcesList.isEmpty())) {
                jsonWriter.key("totalResources");
                jsonWriter.array();
                for (Resource totalResourcesListValue : totalResourcesList) {
                    ListWithAutoConstructFlag stringSetValueList;
                    if (totalResourcesListValue == null) continue;
                    jsonWriter.object();
                    if (totalResourcesListValue.getName() != null) {
                        jsonWriter.key("name").value((Object)totalResourcesListValue.getName());
                    }
                    if (totalResourcesListValue.getType() != null) {
                        jsonWriter.key("type").value((Object)totalResourcesListValue.getType());
                    }
                    if (totalResourcesListValue.getDoubleValue() != null) {
                        jsonWriter.key("doubleValue").value((Object)totalResourcesListValue.getDoubleValue());
                    }
                    if (totalResourcesListValue.getLongValue() != null) {
                        jsonWriter.key("longValue").value((Object)totalResourcesListValue.getLongValue());
                    }
                    if (totalResourcesListValue.getIntegerValue() != null) {
                        jsonWriter.key("integerValue").value((Object)totalResourcesListValue.getIntegerValue());
                    }
                    if (!((stringSetValueList = (ListWithAutoConstructFlag)totalResourcesListValue.getStringSetValue()) == null || stringSetValueList.isAutoConstruct() && stringSetValueList.isEmpty())) {
                        jsonWriter.key("stringSetValue");
                        jsonWriter.array();
                        for (String stringSetValueListValue : stringSetValueList) {
                            if (stringSetValueListValue == null) continue;
                            jsonWriter.value((Object)stringSetValueListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if ((versionInfo = registerContainerInstanceRequest.getVersionInfo()) != null) {
                jsonWriter.key("versionInfo");
                jsonWriter.object();
                if (versionInfo.getAgentVersion() != null) {
                    jsonWriter.key("agentVersion").value((Object)versionInfo.getAgentVersion());
                }
                if (versionInfo.getAgentHash() != null) {
                    jsonWriter.key("agentHash").value((Object)versionInfo.getAgentHash());
                }
                if (versionInfo.getDockerVersion() != null) {
                    jsonWriter.key("dockerVersion").value((Object)versionInfo.getDockerVersion());
                }
                jsonWriter.endObject();
            }
            if (registerContainerInstanceRequest.getContainerInstanceArn() != null) {
                jsonWriter.key("containerInstanceArn").value((Object)registerContainerInstanceRequest.getContainerInstanceArn());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

