/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ecs.AmazonECSAsync;
import com.amazonaws.services.ecs.AmazonECSClient;
import com.amazonaws.services.ecs.model.CreateClusterRequest;
import com.amazonaws.services.ecs.model.CreateClusterResult;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.CreateServiceResult;
import com.amazonaws.services.ecs.model.DeleteClusterRequest;
import com.amazonaws.services.ecs.model.DeleteClusterResult;
import com.amazonaws.services.ecs.model.DeleteServiceRequest;
import com.amazonaws.services.ecs.model.DeleteServiceResult;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeClustersRequest;
import com.amazonaws.services.ecs.model.DescribeClustersResult;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesRequest;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesResult;
import com.amazonaws.services.ecs.model.DescribeServicesRequest;
import com.amazonaws.services.ecs.model.DescribeServicesResult;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.services.ecs.model.DescribeTasksResult;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointRequest;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointResult;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import com.amazonaws.services.ecs.model.ListClustersResult;
import com.amazonaws.services.ecs.model.ListContainerInstancesRequest;
import com.amazonaws.services.ecs.model.ListContainerInstancesResult;
import com.amazonaws.services.ecs.model.ListServicesRequest;
import com.amazonaws.services.ecs.model.ListServicesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsResult;
import com.amazonaws.services.ecs.model.ListTasksRequest;
import com.amazonaws.services.ecs.model.ListTasksResult;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.RunTaskResult;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.StartTaskResult;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.services.ecs.model.StopTaskResult;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeResult;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeResult;
import com.amazonaws.services.ecs.model.UpdateContainerAgentRequest;
import com.amazonaws.services.ecs.model.UpdateContainerAgentResult;
import com.amazonaws.services.ecs.model.UpdateServiceRequest;
import com.amazonaws.services.ecs.model.UpdateServiceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonECSAsyncClient
extends AmazonECSClient
implements AmazonECSAsync {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonECSAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonECSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonECSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonECSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonECSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(final DeleteClusterRequest deleteClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                return AmazonECSAsyncClient.this.deleteCluster(deleteClusterRequest);
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(final DeleteClusterRequest deleteClusterRequest, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result;
                try {
                    result = AmazonECSAsyncClient.this.deleteCluster(deleteClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteClusterRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync(final SubmitContainerStateChangeRequest submitContainerStateChangeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubmitContainerStateChangeResult>(){

            @Override
            public SubmitContainerStateChangeResult call() throws Exception {
                return AmazonECSAsyncClient.this.submitContainerStateChange(submitContainerStateChangeRequest);
            }
        });
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync(final SubmitContainerStateChangeRequest submitContainerStateChangeRequest, final AsyncHandler<SubmitContainerStateChangeRequest, SubmitContainerStateChangeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubmitContainerStateChangeResult>(){

            @Override
            public SubmitContainerStateChangeResult call() throws Exception {
                SubmitContainerStateChangeResult result;
                try {
                    result = AmazonECSAsyncClient.this.submitContainerStateChange(submitContainerStateChangeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)submitContainerStateChangeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteServiceResult> deleteServiceAsync(final DeleteServiceRequest deleteServiceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteServiceResult>(){

            @Override
            public DeleteServiceResult call() throws Exception {
                return AmazonECSAsyncClient.this.deleteService(deleteServiceRequest);
            }
        });
    }

    @Override
    public Future<DeleteServiceResult> deleteServiceAsync(final DeleteServiceRequest deleteServiceRequest, final AsyncHandler<DeleteServiceRequest, DeleteServiceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteServiceResult>(){

            @Override
            public DeleteServiceResult call() throws Exception {
                DeleteServiceResult result;
                try {
                    result = AmazonECSAsyncClient.this.deleteService(deleteServiceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteServiceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync(final ListTaskDefinitionsRequest listTaskDefinitionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTaskDefinitionsResult>(){

            @Override
            public ListTaskDefinitionsResult call() throws Exception {
                return AmazonECSAsyncClient.this.listTaskDefinitions(listTaskDefinitionsRequest);
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync(final ListTaskDefinitionsRequest listTaskDefinitionsRequest, final AsyncHandler<ListTaskDefinitionsRequest, ListTaskDefinitionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTaskDefinitionsResult>(){

            @Override
            public ListTaskDefinitionsResult call() throws Exception {
                ListTaskDefinitionsResult result;
                try {
                    result = AmazonECSAsyncClient.this.listTaskDefinitions(listTaskDefinitionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTaskDefinitionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RunTaskResult> runTaskAsync(final RunTaskRequest runTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RunTaskResult>(){

            @Override
            public RunTaskResult call() throws Exception {
                return AmazonECSAsyncClient.this.runTask(runTaskRequest);
            }
        });
    }

    @Override
    public Future<RunTaskResult> runTaskAsync(final RunTaskRequest runTaskRequest, final AsyncHandler<RunTaskRequest, RunTaskResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RunTaskResult>(){

            @Override
            public RunTaskResult call() throws Exception {
                RunTaskResult result;
                try {
                    result = AmazonECSAsyncClient.this.runTask(runTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)runTaskRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(final ListClustersRequest listClustersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                return AmazonECSAsyncClient.this.listClusters(listClustersRequest);
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(final ListClustersRequest listClustersRequest, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result;
                try {
                    result = AmazonECSAsyncClient.this.listClusters(listClustersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listClustersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(final CreateClusterRequest createClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                return AmazonECSAsyncClient.this.createCluster(createClusterRequest);
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(final CreateClusterRequest createClusterRequest, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result;
                try {
                    result = AmazonECSAsyncClient.this.createCluster(createClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createClusterRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(final DescribeClustersRequest describeClustersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                return AmazonECSAsyncClient.this.describeClusters(describeClustersRequest);
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(final DescribeClustersRequest describeClustersRequest, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeClusters(describeClustersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeClustersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterTaskDefinitionResult> deregisterTaskDefinitionAsync(final DeregisterTaskDefinitionRequest deregisterTaskDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeregisterTaskDefinitionResult>(){

            @Override
            public DeregisterTaskDefinitionResult call() throws Exception {
                return AmazonECSAsyncClient.this.deregisterTaskDefinition(deregisterTaskDefinitionRequest);
            }
        });
    }

    @Override
    public Future<DeregisterTaskDefinitionResult> deregisterTaskDefinitionAsync(final DeregisterTaskDefinitionRequest deregisterTaskDefinitionRequest, final AsyncHandler<DeregisterTaskDefinitionRequest, DeregisterTaskDefinitionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeregisterTaskDefinitionResult>(){

            @Override
            public DeregisterTaskDefinitionResult call() throws Exception {
                DeregisterTaskDefinitionResult result;
                try {
                    result = AmazonECSAsyncClient.this.deregisterTaskDefinition(deregisterTaskDefinitionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deregisterTaskDefinitionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterContainerInstanceResult> deregisterContainerInstanceAsync(final DeregisterContainerInstanceRequest deregisterContainerInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeregisterContainerInstanceResult>(){

            @Override
            public DeregisterContainerInstanceResult call() throws Exception {
                return AmazonECSAsyncClient.this.deregisterContainerInstance(deregisterContainerInstanceRequest);
            }
        });
    }

    @Override
    public Future<DeregisterContainerInstanceResult> deregisterContainerInstanceAsync(final DeregisterContainerInstanceRequest deregisterContainerInstanceRequest, final AsyncHandler<DeregisterContainerInstanceRequest, DeregisterContainerInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeregisterContainerInstanceResult>(){

            @Override
            public DeregisterContainerInstanceResult call() throws Exception {
                DeregisterContainerInstanceResult result;
                try {
                    result = AmazonECSAsyncClient.this.deregisterContainerInstance(deregisterContainerInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deregisterContainerInstanceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync(final ListContainerInstancesRequest listContainerInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListContainerInstancesResult>(){

            @Override
            public ListContainerInstancesResult call() throws Exception {
                return AmazonECSAsyncClient.this.listContainerInstances(listContainerInstancesRequest);
            }
        });
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync(final ListContainerInstancesRequest listContainerInstancesRequest, final AsyncHandler<ListContainerInstancesRequest, ListContainerInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListContainerInstancesResult>(){

            @Override
            public ListContainerInstancesResult call() throws Exception {
                ListContainerInstancesResult result;
                try {
                    result = AmazonECSAsyncClient.this.listContainerInstances(listContainerInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listContainerInstancesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContainerAgentResult> updateContainerAgentAsync(final UpdateContainerAgentRequest updateContainerAgentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateContainerAgentResult>(){

            @Override
            public UpdateContainerAgentResult call() throws Exception {
                return AmazonECSAsyncClient.this.updateContainerAgent(updateContainerAgentRequest);
            }
        });
    }

    @Override
    public Future<UpdateContainerAgentResult> updateContainerAgentAsync(final UpdateContainerAgentRequest updateContainerAgentRequest, final AsyncHandler<UpdateContainerAgentRequest, UpdateContainerAgentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateContainerAgentResult>(){

            @Override
            public UpdateContainerAgentResult call() throws Exception {
                UpdateContainerAgentResult result;
                try {
                    result = AmazonECSAsyncClient.this.updateContainerAgent(updateContainerAgentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateContainerAgentRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTaskDefinitionResult> describeTaskDefinitionAsync(final DescribeTaskDefinitionRequest describeTaskDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTaskDefinitionResult>(){

            @Override
            public DescribeTaskDefinitionResult call() throws Exception {
                return AmazonECSAsyncClient.this.describeTaskDefinition(describeTaskDefinitionRequest);
            }
        });
    }

    @Override
    public Future<DescribeTaskDefinitionResult> describeTaskDefinitionAsync(final DescribeTaskDefinitionRequest describeTaskDefinitionRequest, final AsyncHandler<DescribeTaskDefinitionRequest, DescribeTaskDefinitionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTaskDefinitionResult>(){

            @Override
            public DescribeTaskDefinitionResult call() throws Exception {
                DescribeTaskDefinitionResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeTaskDefinition(describeTaskDefinitionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTaskDefinitionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RegisterTaskDefinitionResult> registerTaskDefinitionAsync(final RegisterTaskDefinitionRequest registerTaskDefinitionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterTaskDefinitionResult>(){

            @Override
            public RegisterTaskDefinitionResult call() throws Exception {
                return AmazonECSAsyncClient.this.registerTaskDefinition(registerTaskDefinitionRequest);
            }
        });
    }

    @Override
    public Future<RegisterTaskDefinitionResult> registerTaskDefinitionAsync(final RegisterTaskDefinitionRequest registerTaskDefinitionRequest, final AsyncHandler<RegisterTaskDefinitionRequest, RegisterTaskDefinitionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterTaskDefinitionResult>(){

            @Override
            public RegisterTaskDefinitionResult call() throws Exception {
                RegisterTaskDefinitionResult result;
                try {
                    result = AmazonECSAsyncClient.this.registerTaskDefinition(registerTaskDefinitionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)registerTaskDefinitionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<SubmitTaskStateChangeResult> submitTaskStateChangeAsync(final SubmitTaskStateChangeRequest submitTaskStateChangeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubmitTaskStateChangeResult>(){

            @Override
            public SubmitTaskStateChangeResult call() throws Exception {
                return AmazonECSAsyncClient.this.submitTaskStateChange(submitTaskStateChangeRequest);
            }
        });
    }

    @Override
    public Future<SubmitTaskStateChangeResult> submitTaskStateChangeAsync(final SubmitTaskStateChangeRequest submitTaskStateChangeRequest, final AsyncHandler<SubmitTaskStateChangeRequest, SubmitTaskStateChangeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubmitTaskStateChangeResult>(){

            @Override
            public SubmitTaskStateChangeResult call() throws Exception {
                SubmitTaskStateChangeResult result;
                try {
                    result = AmazonECSAsyncClient.this.submitTaskStateChange(submitTaskStateChangeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)submitTaskStateChangeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateServiceResult> createServiceAsync(final CreateServiceRequest createServiceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateServiceResult>(){

            @Override
            public CreateServiceResult call() throws Exception {
                return AmazonECSAsyncClient.this.createService(createServiceRequest);
            }
        });
    }

    @Override
    public Future<CreateServiceResult> createServiceAsync(final CreateServiceRequest createServiceRequest, final AsyncHandler<CreateServiceRequest, CreateServiceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateServiceResult>(){

            @Override
            public CreateServiceResult call() throws Exception {
                CreateServiceResult result;
                try {
                    result = AmazonECSAsyncClient.this.createService(createServiceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createServiceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeContainerInstancesResult> describeContainerInstancesAsync(final DescribeContainerInstancesRequest describeContainerInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeContainerInstancesResult>(){

            @Override
            public DescribeContainerInstancesResult call() throws Exception {
                return AmazonECSAsyncClient.this.describeContainerInstances(describeContainerInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeContainerInstancesResult> describeContainerInstancesAsync(final DescribeContainerInstancesRequest describeContainerInstancesRequest, final AsyncHandler<DescribeContainerInstancesRequest, DescribeContainerInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeContainerInstancesResult>(){

            @Override
            public DescribeContainerInstancesResult call() throws Exception {
                DescribeContainerInstancesResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeContainerInstances(describeContainerInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeContainerInstancesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RegisterContainerInstanceResult> registerContainerInstanceAsync(final RegisterContainerInstanceRequest registerContainerInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterContainerInstanceResult>(){

            @Override
            public RegisterContainerInstanceResult call() throws Exception {
                return AmazonECSAsyncClient.this.registerContainerInstance(registerContainerInstanceRequest);
            }
        });
    }

    @Override
    public Future<RegisterContainerInstanceResult> registerContainerInstanceAsync(final RegisterContainerInstanceRequest registerContainerInstanceRequest, final AsyncHandler<RegisterContainerInstanceRequest, RegisterContainerInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterContainerInstanceResult>(){

            @Override
            public RegisterContainerInstanceResult call() throws Exception {
                RegisterContainerInstanceResult result;
                try {
                    result = AmazonECSAsyncClient.this.registerContainerInstance(registerContainerInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)registerContainerInstanceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(final DescribeServicesRequest describeServicesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                return AmazonECSAsyncClient.this.describeServices(describeServicesRequest);
            }
        });
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(final DescribeServicesRequest describeServicesRequest, final AsyncHandler<DescribeServicesRequest, DescribeServicesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                DescribeServicesResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeServices(describeServicesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeServicesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(final ListServicesRequest listServicesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListServicesResult>(){

            @Override
            public ListServicesResult call() throws Exception {
                return AmazonECSAsyncClient.this.listServices(listServicesRequest);
            }
        });
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(final ListServicesRequest listServicesRequest, final AsyncHandler<ListServicesRequest, ListServicesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListServicesResult>(){

            @Override
            public ListServicesResult call() throws Exception {
                ListServicesResult result;
                try {
                    result = AmazonECSAsyncClient.this.listServices(listServicesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listServicesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServiceResult> updateServiceAsync(final UpdateServiceRequest updateServiceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateServiceResult>(){

            @Override
            public UpdateServiceResult call() throws Exception {
                return AmazonECSAsyncClient.this.updateService(updateServiceRequest);
            }
        });
    }

    @Override
    public Future<UpdateServiceResult> updateServiceAsync(final UpdateServiceRequest updateServiceRequest, final AsyncHandler<UpdateServiceRequest, UpdateServiceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateServiceResult>(){

            @Override
            public UpdateServiceResult call() throws Exception {
                UpdateServiceResult result;
                try {
                    result = AmazonECSAsyncClient.this.updateService(updateServiceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateServiceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync(final ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTaskDefinitionFamiliesResult>(){

            @Override
            public ListTaskDefinitionFamiliesResult call() throws Exception {
                return AmazonECSAsyncClient.this.listTaskDefinitionFamilies(listTaskDefinitionFamiliesRequest);
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync(final ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest, final AsyncHandler<ListTaskDefinitionFamiliesRequest, ListTaskDefinitionFamiliesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTaskDefinitionFamiliesResult>(){

            @Override
            public ListTaskDefinitionFamiliesResult call() throws Exception {
                ListTaskDefinitionFamiliesResult result;
                try {
                    result = AmazonECSAsyncClient.this.listTaskDefinitionFamilies(listTaskDefinitionFamiliesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTaskDefinitionFamiliesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTasksResult> describeTasksAsync(final DescribeTasksRequest describeTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTasksResult>(){

            @Override
            public DescribeTasksResult call() throws Exception {
                return AmazonECSAsyncClient.this.describeTasks(describeTasksRequest);
            }
        });
    }

    @Override
    public Future<DescribeTasksResult> describeTasksAsync(final DescribeTasksRequest describeTasksRequest, final AsyncHandler<DescribeTasksRequest, DescribeTasksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTasksResult>(){

            @Override
            public DescribeTasksResult call() throws Exception {
                DescribeTasksResult result;
                try {
                    result = AmazonECSAsyncClient.this.describeTasks(describeTasksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTasksRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync(final DiscoverPollEndpointRequest discoverPollEndpointRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DiscoverPollEndpointResult>(){

            @Override
            public DiscoverPollEndpointResult call() throws Exception {
                return AmazonECSAsyncClient.this.discoverPollEndpoint(discoverPollEndpointRequest);
            }
        });
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync(final DiscoverPollEndpointRequest discoverPollEndpointRequest, final AsyncHandler<DiscoverPollEndpointRequest, DiscoverPollEndpointResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DiscoverPollEndpointResult>(){

            @Override
            public DiscoverPollEndpointResult call() throws Exception {
                DiscoverPollEndpointResult result;
                try {
                    result = AmazonECSAsyncClient.this.discoverPollEndpoint(discoverPollEndpointRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)discoverPollEndpointRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<StartTaskResult> startTaskAsync(final StartTaskRequest startTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartTaskResult>(){

            @Override
            public StartTaskResult call() throws Exception {
                return AmazonECSAsyncClient.this.startTask(startTaskRequest);
            }
        });
    }

    @Override
    public Future<StartTaskResult> startTaskAsync(final StartTaskRequest startTaskRequest, final AsyncHandler<StartTaskRequest, StartTaskResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartTaskResult>(){

            @Override
            public StartTaskResult call() throws Exception {
                StartTaskResult result;
                try {
                    result = AmazonECSAsyncClient.this.startTask(startTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)startTaskRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(final ListTasksRequest listTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTasksResult>(){

            @Override
            public ListTasksResult call() throws Exception {
                return AmazonECSAsyncClient.this.listTasks(listTasksRequest);
            }
        });
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(final ListTasksRequest listTasksRequest, final AsyncHandler<ListTasksRequest, ListTasksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTasksResult>(){

            @Override
            public ListTasksResult call() throws Exception {
                ListTasksResult result;
                try {
                    result = AmazonECSAsyncClient.this.listTasks(listTasksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTasksRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<StopTaskResult> stopTaskAsync(final StopTaskRequest stopTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StopTaskResult>(){

            @Override
            public StopTaskResult call() throws Exception {
                return AmazonECSAsyncClient.this.stopTask(stopTaskRequest);
            }
        });
    }

    @Override
    public Future<StopTaskResult> stopTaskAsync(final StopTaskRequest stopTaskRequest, final AsyncHandler<StopTaskRequest, StopTaskResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StopTaskResult>(){

            @Override
            public StopTaskResult call() throws Exception {
                StopTaskResult result;
                try {
                    result = AmazonECSAsyncClient.this.stopTask(stopTaskRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)stopTaskRequest, (Object)result);
                return result;
            }
        });
    }
}

