/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecrpublic.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ecrpublic.model.RepositoryCatalogDataInput;
import com.amazonaws.services.ecrpublic.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRepositoryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String repositoryName;
    private RepositoryCatalogDataInput catalogData;
    private List<Tag> tags;

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public CreateRepositoryRequest withRepositoryName(String repositoryName) {
        this.setRepositoryName(repositoryName);
        return this;
    }

    public void setCatalogData(RepositoryCatalogDataInput catalogData) {
        this.catalogData = catalogData;
    }

    public RepositoryCatalogDataInput getCatalogData() {
        return this.catalogData;
    }

    public CreateRepositoryRequest withCatalogData(RepositoryCatalogDataInput catalogData) {
        this.setCatalogData(catalogData);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateRepositoryRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateRepositoryRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepositoryName() != null) {
            sb.append("RepositoryName: ").append(this.getRepositoryName()).append(",");
        }
        if (this.getCatalogData() != null) {
            sb.append("CatalogData: ").append(this.getCatalogData()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest)obj;
        if (other.getRepositoryName() == null ^ this.getRepositoryName() == null) {
            return false;
        }
        if (other.getRepositoryName() != null && !other.getRepositoryName().equals(this.getRepositoryName())) {
            return false;
        }
        if (other.getCatalogData() == null ^ this.getCatalogData() == null) {
            return false;
        }
        if (other.getCatalogData() != null && !other.getCatalogData().equals(this.getCatalogData())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepositoryName() == null ? 0 : this.getRepositoryName().hashCode());
        hashCode = 31 * hashCode + (this.getCatalogData() == null ? 0 : this.getCatalogData().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateRepositoryRequest clone() {
        return (CreateRepositoryRequest)super.clone();
    }
}

