/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecr.model.CvssScore;
import com.amazonaws.services.ecr.model.VulnerablePackage;
import com.amazonaws.services.ecr.model.transform.PackageVulnerabilityDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PackageVulnerabilityDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private List<CvssScore> cvss;
    private List<String> referenceUrls;
    private List<String> relatedVulnerabilities;
    private String source;
    private String sourceUrl;
    private Date vendorCreatedAt;
    private String vendorSeverity;
    private Date vendorUpdatedAt;
    private String vulnerabilityId;
    private List<VulnerablePackage> vulnerablePackages;

    public List<CvssScore> getCvss() {
        return this.cvss;
    }

    public void setCvss(Collection<CvssScore> cvss) {
        if (cvss == null) {
            this.cvss = null;
            return;
        }
        this.cvss = new ArrayList<CvssScore>(cvss);
    }

    public PackageVulnerabilityDetails withCvss(CvssScore ... cvss) {
        if (this.cvss == null) {
            this.setCvss(new ArrayList<CvssScore>(cvss.length));
        }
        for (CvssScore ele : cvss) {
            this.cvss.add(ele);
        }
        return this;
    }

    public PackageVulnerabilityDetails withCvss(Collection<CvssScore> cvss) {
        this.setCvss(cvss);
        return this;
    }

    public List<String> getReferenceUrls() {
        return this.referenceUrls;
    }

    public void setReferenceUrls(Collection<String> referenceUrls) {
        if (referenceUrls == null) {
            this.referenceUrls = null;
            return;
        }
        this.referenceUrls = new ArrayList<String>(referenceUrls);
    }

    public PackageVulnerabilityDetails withReferenceUrls(String ... referenceUrls) {
        if (this.referenceUrls == null) {
            this.setReferenceUrls(new ArrayList<String>(referenceUrls.length));
        }
        for (String ele : referenceUrls) {
            this.referenceUrls.add(ele);
        }
        return this;
    }

    public PackageVulnerabilityDetails withReferenceUrls(Collection<String> referenceUrls) {
        this.setReferenceUrls(referenceUrls);
        return this;
    }

    public List<String> getRelatedVulnerabilities() {
        return this.relatedVulnerabilities;
    }

    public void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
        if (relatedVulnerabilities == null) {
            this.relatedVulnerabilities = null;
            return;
        }
        this.relatedVulnerabilities = new ArrayList<String>(relatedVulnerabilities);
    }

    public PackageVulnerabilityDetails withRelatedVulnerabilities(String ... relatedVulnerabilities) {
        if (this.relatedVulnerabilities == null) {
            this.setRelatedVulnerabilities(new ArrayList<String>(relatedVulnerabilities.length));
        }
        for (String ele : relatedVulnerabilities) {
            this.relatedVulnerabilities.add(ele);
        }
        return this;
    }

    public PackageVulnerabilityDetails withRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
        this.setRelatedVulnerabilities(relatedVulnerabilities);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public PackageVulnerabilityDetails withSource(String source) {
        this.setSource(source);
        return this;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public PackageVulnerabilityDetails withSourceUrl(String sourceUrl) {
        this.setSourceUrl(sourceUrl);
        return this;
    }

    public void setVendorCreatedAt(Date vendorCreatedAt) {
        this.vendorCreatedAt = vendorCreatedAt;
    }

    public Date getVendorCreatedAt() {
        return this.vendorCreatedAt;
    }

    public PackageVulnerabilityDetails withVendorCreatedAt(Date vendorCreatedAt) {
        this.setVendorCreatedAt(vendorCreatedAt);
        return this;
    }

    public void setVendorSeverity(String vendorSeverity) {
        this.vendorSeverity = vendorSeverity;
    }

    public String getVendorSeverity() {
        return this.vendorSeverity;
    }

    public PackageVulnerabilityDetails withVendorSeverity(String vendorSeverity) {
        this.setVendorSeverity(vendorSeverity);
        return this;
    }

    public void setVendorUpdatedAt(Date vendorUpdatedAt) {
        this.vendorUpdatedAt = vendorUpdatedAt;
    }

    public Date getVendorUpdatedAt() {
        return this.vendorUpdatedAt;
    }

    public PackageVulnerabilityDetails withVendorUpdatedAt(Date vendorUpdatedAt) {
        this.setVendorUpdatedAt(vendorUpdatedAt);
        return this;
    }

    public void setVulnerabilityId(String vulnerabilityId) {
        this.vulnerabilityId = vulnerabilityId;
    }

    public String getVulnerabilityId() {
        return this.vulnerabilityId;
    }

    public PackageVulnerabilityDetails withVulnerabilityId(String vulnerabilityId) {
        this.setVulnerabilityId(vulnerabilityId);
        return this;
    }

    public List<VulnerablePackage> getVulnerablePackages() {
        return this.vulnerablePackages;
    }

    public void setVulnerablePackages(Collection<VulnerablePackage> vulnerablePackages) {
        if (vulnerablePackages == null) {
            this.vulnerablePackages = null;
            return;
        }
        this.vulnerablePackages = new ArrayList<VulnerablePackage>(vulnerablePackages);
    }

    public PackageVulnerabilityDetails withVulnerablePackages(VulnerablePackage ... vulnerablePackages) {
        if (this.vulnerablePackages == null) {
            this.setVulnerablePackages(new ArrayList<VulnerablePackage>(vulnerablePackages.length));
        }
        for (VulnerablePackage ele : vulnerablePackages) {
            this.vulnerablePackages.add(ele);
        }
        return this;
    }

    public PackageVulnerabilityDetails withVulnerablePackages(Collection<VulnerablePackage> vulnerablePackages) {
        this.setVulnerablePackages(vulnerablePackages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCvss() != null) {
            sb.append("Cvss: ").append(this.getCvss()).append(",");
        }
        if (this.getReferenceUrls() != null) {
            sb.append("ReferenceUrls: ").append(this.getReferenceUrls()).append(",");
        }
        if (this.getRelatedVulnerabilities() != null) {
            sb.append("RelatedVulnerabilities: ").append(this.getRelatedVulnerabilities()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getSourceUrl() != null) {
            sb.append("SourceUrl: ").append(this.getSourceUrl()).append(",");
        }
        if (this.getVendorCreatedAt() != null) {
            sb.append("VendorCreatedAt: ").append(this.getVendorCreatedAt()).append(",");
        }
        if (this.getVendorSeverity() != null) {
            sb.append("VendorSeverity: ").append(this.getVendorSeverity()).append(",");
        }
        if (this.getVendorUpdatedAt() != null) {
            sb.append("VendorUpdatedAt: ").append(this.getVendorUpdatedAt()).append(",");
        }
        if (this.getVulnerabilityId() != null) {
            sb.append("VulnerabilityId: ").append(this.getVulnerabilityId()).append(",");
        }
        if (this.getVulnerablePackages() != null) {
            sb.append("VulnerablePackages: ").append(this.getVulnerablePackages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVulnerabilityDetails)) {
            return false;
        }
        PackageVulnerabilityDetails other = (PackageVulnerabilityDetails)obj;
        if (other.getCvss() == null ^ this.getCvss() == null) {
            return false;
        }
        if (other.getCvss() != null && !other.getCvss().equals(this.getCvss())) {
            return false;
        }
        if (other.getReferenceUrls() == null ^ this.getReferenceUrls() == null) {
            return false;
        }
        if (other.getReferenceUrls() != null && !other.getReferenceUrls().equals(this.getReferenceUrls())) {
            return false;
        }
        if (other.getRelatedVulnerabilities() == null ^ this.getRelatedVulnerabilities() == null) {
            return false;
        }
        if (other.getRelatedVulnerabilities() != null && !other.getRelatedVulnerabilities().equals(this.getRelatedVulnerabilities())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getSourceUrl() == null ^ this.getSourceUrl() == null) {
            return false;
        }
        if (other.getSourceUrl() != null && !other.getSourceUrl().equals(this.getSourceUrl())) {
            return false;
        }
        if (other.getVendorCreatedAt() == null ^ this.getVendorCreatedAt() == null) {
            return false;
        }
        if (other.getVendorCreatedAt() != null && !other.getVendorCreatedAt().equals(this.getVendorCreatedAt())) {
            return false;
        }
        if (other.getVendorSeverity() == null ^ this.getVendorSeverity() == null) {
            return false;
        }
        if (other.getVendorSeverity() != null && !other.getVendorSeverity().equals(this.getVendorSeverity())) {
            return false;
        }
        if (other.getVendorUpdatedAt() == null ^ this.getVendorUpdatedAt() == null) {
            return false;
        }
        if (other.getVendorUpdatedAt() != null && !other.getVendorUpdatedAt().equals(this.getVendorUpdatedAt())) {
            return false;
        }
        if (other.getVulnerabilityId() == null ^ this.getVulnerabilityId() == null) {
            return false;
        }
        if (other.getVulnerabilityId() != null && !other.getVulnerabilityId().equals(this.getVulnerabilityId())) {
            return false;
        }
        if (other.getVulnerablePackages() == null ^ this.getVulnerablePackages() == null) {
            return false;
        }
        return other.getVulnerablePackages() == null || other.getVulnerablePackages().equals(this.getVulnerablePackages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCvss() == null ? 0 : this.getCvss().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceUrls() == null ? 0 : this.getReferenceUrls().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedVulnerabilities() == null ? 0 : this.getRelatedVulnerabilities().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getSourceUrl() == null ? 0 : this.getSourceUrl().hashCode());
        hashCode = 31 * hashCode + (this.getVendorCreatedAt() == null ? 0 : this.getVendorCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getVendorSeverity() == null ? 0 : this.getVendorSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getVendorUpdatedAt() == null ? 0 : this.getVendorUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getVulnerabilityId() == null ? 0 : this.getVulnerabilityId().hashCode());
        hashCode = 31 * hashCode + (this.getVulnerablePackages() == null ? 0 : this.getVulnerablePackages().hashCode());
        return hashCode;
    }

    public PackageVulnerabilityDetails clone() {
        try {
            return (PackageVulnerabilityDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageVulnerabilityDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

