/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.services.ecr.model.Layer;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class LayerJsonUnmarshaller
implements Unmarshaller<Layer, JsonUnmarshallerContext> {
    private static LayerJsonUnmarshaller instance;

    public Layer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Layer layer = new Layer();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("layerDigest", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setLayerDigest((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("layerAvailability", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setLayerAvailability((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("layerSize", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setLayerSize((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("mediaType", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    layer.setMediaType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return layer;
    }

    public static LayerJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LayerJsonUnmarshaller();
        }
        return instance;
    }
}

