/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecr.model.ScanFrequency;
import com.amazonaws.services.ecr.model.ScanningRepositoryFilter;
import com.amazonaws.services.ecr.model.transform.RegistryScanningRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RegistryScanningRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String scanFrequency;
    private List<ScanningRepositoryFilter> repositoryFilters;

    public void setScanFrequency(String scanFrequency) {
        this.scanFrequency = scanFrequency;
    }

    public String getScanFrequency() {
        return this.scanFrequency;
    }

    public RegistryScanningRule withScanFrequency(String scanFrequency) {
        this.setScanFrequency(scanFrequency);
        return this;
    }

    public RegistryScanningRule withScanFrequency(ScanFrequency scanFrequency) {
        this.scanFrequency = scanFrequency.toString();
        return this;
    }

    public List<ScanningRepositoryFilter> getRepositoryFilters() {
        return this.repositoryFilters;
    }

    public void setRepositoryFilters(Collection<ScanningRepositoryFilter> repositoryFilters) {
        if (repositoryFilters == null) {
            this.repositoryFilters = null;
            return;
        }
        this.repositoryFilters = new ArrayList<ScanningRepositoryFilter>(repositoryFilters);
    }

    public RegistryScanningRule withRepositoryFilters(ScanningRepositoryFilter ... repositoryFilters) {
        if (this.repositoryFilters == null) {
            this.setRepositoryFilters(new ArrayList<ScanningRepositoryFilter>(repositoryFilters.length));
        }
        for (ScanningRepositoryFilter ele : repositoryFilters) {
            this.repositoryFilters.add(ele);
        }
        return this;
    }

    public RegistryScanningRule withRepositoryFilters(Collection<ScanningRepositoryFilter> repositoryFilters) {
        this.setRepositoryFilters(repositoryFilters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScanFrequency() != null) {
            sb.append("ScanFrequency: ").append(this.getScanFrequency()).append(",");
        }
        if (this.getRepositoryFilters() != null) {
            sb.append("RepositoryFilters: ").append(this.getRepositoryFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistryScanningRule)) {
            return false;
        }
        RegistryScanningRule other = (RegistryScanningRule)obj;
        if (other.getScanFrequency() == null ^ this.getScanFrequency() == null) {
            return false;
        }
        if (other.getScanFrequency() != null && !other.getScanFrequency().equals(this.getScanFrequency())) {
            return false;
        }
        if (other.getRepositoryFilters() == null ^ this.getRepositoryFilters() == null) {
            return false;
        }
        return other.getRepositoryFilters() == null || other.getRepositoryFilters().equals(this.getRepositoryFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScanFrequency() == null ? 0 : this.getScanFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getRepositoryFilters() == null ? 0 : this.getRepositoryFilters().hashCode());
        return hashCode;
    }

    public RegistryScanningRule clone() {
        try {
            return (RegistryScanningRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegistryScanningRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

